/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.pushdown.inner;

import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.state.pushdown.filter.FilterType;
import com.antgroup.geaflow.state.pushdown.filter.IFilter;
import com.antgroup.geaflow.state.pushdown.filter.OrFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.EmptyGraphFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.GeneratedQueryFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.GraphFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.IGraphFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.OrGraphFilter;
import com.antgroup.geaflow.state.pushdown.inner.FilterGenerator;
import com.antgroup.geaflow.state.pushdown.inner.FilterPlanWithData;
import com.antgroup.geaflow.state.pushdown.inner.IFilterConverter;
import com.antgroup.geaflow.state.pushdown.inner.PushDownPb;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.protobuf.ProtocolStringList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.codehaus.janino.SimpleCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGenFilterConverter
implements IFilterConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeGenFilterConverter.class);
    private static final String CODE_GEN_PACKAGE = "com.antgroup.geaflow.state.pushdown.filter.inner.";
    private static final String TEMPLATE_FILE_NAME = "Filter.template";
    private static final String FILTER_CLASS_HEADER = "GraphFilter_";
    private static final String TEMPLATE;
    private static final AtomicLong COUNTER;
    private static final int CACHE_SIZE = 1024;
    private static final Cache<PushDownPb.FilterNode, IGraphFilter> FILTER_CACHE;

    @Override
    public IFilter convert(IFilter origin) {
        if (origin.getFilterType() == FilterType.EMPTY) {
            return EmptyGraphFilter.of();
        }
        if (origin.getFilterType() == FilterType.OR && ((OrFilter)origin).isSingleLimit()) {
            List<IGraphFilter> list = ((OrFilter)origin).getFilters().stream().map(f -> (IGraphFilter)this.innerConvert((IFilter)f)).collect(Collectors.toList());
            return new OrGraphFilter(list);
        }
        return this.innerConvert(origin);
    }

    private IFilter innerConvert(IFilter origin) {
        try {
            FilterPlanWithData planWithData = FilterGenerator.getFilterPlanWithData(origin);
            IGraphFilter filter = (IGraphFilter)FILTER_CACHE.getIfPresent((Object)planWithData.plan);
            if (filter == null) {
                filter = (IGraphFilter)this.convert(planWithData.plan);
                FILTER_CACHE.put((Object)planWithData.plan, (Object)filter);
            }
            IGraphFilter genFilter = filter.clone();
            VariableContext varContext = new VariableContext();
            CodeGenFilterConverter.variableGen(planWithData.data, varContext);
            ((GeneratedQueryFilter)((Object)genFilter)).initVariables(varContext.variables.toArray(new Object[0]));
            return genFilter;
        }
        catch (Exception ex) {
            LOGGER.warn("code gen fail {}, return origin", (Object)ex.getMessage());
            return GraphFilter.of(origin);
        }
    }

    @Override
    public IFilter convert(PushDownPb.FilterNode filterNode) {
        String className = FILTER_CLASS_HEADER + COUNTER.getAndIncrement();
        String src = this.codeGen(className, filterNode);
        try {
            SimpleCompiler compiler = new SimpleCompiler();
            compiler.cook(src);
            Class<?> aClass = compiler.getClassLoader().loadClass(CODE_GEN_PACKAGE + className);
            return (IGraphFilter)aClass.newInstance();
        }
        catch (Exception e) {
            LOGGER.error("code gen compile fail\n{}", (Object)src);
            throw new RuntimeException(e);
        }
    }

    private String codeGen(String className, PushDownPb.FilterNode filterNode) {
        CodeGenContext context = new CodeGenContext(new AtomicInteger(0));
        CodeGenFilterConverter.innerCodeGen(filterNode, context);
        return context.getCode(className);
    }

    private static void variableGen(PushDownPb.FilterNode filterNode, VariableContext context) {
        if (filterNode.getFiltersCount() == 0) {
            switch (filterNode.getContentCase()) {
                case INT_CONTENT: {
                    context.variables.addAll(filterNode.getIntContent().getIntList());
                    break;
                }
                case BYTES_CONTENT: {
                    context.variables.addAll(filterNode.getBytesContent().getBytesList());
                    break;
                }
                case LONG_CONTENT: {
                    context.variables.addAll(filterNode.getLongContent().getLongList());
                    break;
                }
                case STR_CONTENT: {
                    ProtocolStringList list = filterNode.getStrContent().getStrList();
                    PushDownPb.FilterType type = filterNode.getFilterType();
                    if (type == PushDownPb.FilterType.VERTEX_LABEL || type == PushDownPb.FilterType.EDGE_LABEL) {
                        context.variables.add(new HashSet(list));
                        break;
                    }
                    context.variables.add(list);
                    break;
                }
            }
        } else {
            List<PushDownPb.FilterNode> filterNodes = filterNode.getFiltersList();
            for (PushDownPb.FilterNode inNode : filterNodes) {
                CodeGenFilterConverter.variableGen(inNode, context);
            }
        }
    }

    private static void innerCodeGen(PushDownPb.FilterNode filterNode, CodeGenContext context) {
        PushDownPb.FilterType type = filterNode.getFilterType();
        switch (type) {
            case AND: {
                CodeGenContext inContext = new CodeGenContext(context.varIdx);
                for (PushDownPb.FilterNode node : filterNode.getFiltersList()) {
                    CodeGenFilterConverter.innerCodeGen(node, inContext);
                }
                inContext.doAnd();
                context.merge(inContext);
                break;
            }
            case OR: {
                CodeGenContext inContext = new CodeGenContext(context.varIdx);
                for (PushDownPb.FilterNode node : filterNode.getFiltersList()) {
                    CodeGenFilterConverter.innerCodeGen(node, inContext);
                }
                inContext.doOr();
                context.merge(inContext);
                break;
            }
            case VERTEX_LABEL: {
                context.addVertexPreCompute(type);
                context.addVertexFormula(String.format("((Set<String>)var[%d]).contains(label)", context.varIdx.getAndIncrement()));
                break;
            }
            case EDGE_LABEL: {
                context.addEdgePreCompute(type);
                context.addEdgeFormula(String.format("((Set<String>)var[%d]).contains(label)", context.varIdx.getAndIncrement()));
                break;
            }
            case VERTEX_TS: {
                context.addVertexPreCompute(type);
                int start = context.varIdx.getAndIncrement();
                int end = context.varIdx.getAndIncrement();
                context.addVertexFormula(String.format("ts >= (Long)var[%d] && ts < (Long)var[%d]", start, end));
                break;
            }
            case EDGE_TS: {
                context.addEdgePreCompute(type);
                int start = context.varIdx.getAndIncrement();
                int end = context.varIdx.getAndIncrement();
                context.addEdgeFormula(String.format("ts >= (Long)var[%d] && ts < (Long)var[%d]", start, end));
                break;
            }
            case IN_EDGE: {
                context.addEdgeFormula("edge.getDirect() == EdgeDirection.IN");
                break;
            }
            case OUT_EDGE: {
                context.addEdgeFormula("edge.getDirect() == EdgeDirection.OUT");
                break;
            }
            case VERTEX_VALUE_DROP: {
                context.addVertexPreCompute(type);
                break;
            }
            case EDGE_VALUE_DROP: {
                context.addEdgePreCompute(type);
                break;
            }
            case VERTEX_MUST_CONTAIN: {
                context.addOneDegreeFormula("oneDegreeGraph.getVertex() != null");
                break;
            }
            default: {
                throw new GeaflowRuntimeException("not find type" + (Object)((Object)type));
            }
        }
    }

    static {
        COUNTER = new AtomicLong(0L);
        FILTER_CACHE = CacheBuilder.newBuilder().initialCapacity(1024).build();
        try (InputStream is = CodeGenFilterConverter.class.getClassLoader().getResourceAsStream(TEMPLATE_FILE_NAME);){
            TEMPLATE = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class VariableContext {
        private List<Object> variables = new ArrayList<Object>();
    }

    public static class CodeGenContext {
        private Set<PushDownPb.FilterType> edgePreFields = new HashSet<PushDownPb.FilterType>();
        private Set<PushDownPb.FilterType> vertexPreFields = new HashSet<PushDownPb.FilterType>();
        private List<String> edgeFormulas = new ArrayList<String>();
        private List<String> vertexFormulas = new ArrayList<String>();
        private List<String> oneDegreeFormulas = new ArrayList<String>();
        private AtomicInteger varIdx;

        public CodeGenContext(AtomicInteger varIdx) {
            this.varIdx = varIdx;
        }

        private String getPreComputeCode(PushDownPb.FilterType type) {
            switch (type) {
                case VERTEX_TS: {
                    return "long ts = ((IGraphElementWithTimeField)vertex).getTime();";
                }
                case EDGE_TS: {
                    return "long ts = ((IGraphElementWithTimeField)edge).getTime();";
                }
                case VERTEX_LABEL: {
                    return "String label = ((IGraphElementWithLabelField)vertex).getLabel();";
                }
                case EDGE_LABEL: {
                    return "String label = ((IGraphElementWithLabelField)edge).getLabel();";
                }
                case VERTEX_VALUE_DROP: {
                    return "vertex.withValue(null);";
                }
                case EDGE_VALUE_DROP: {
                    return "edge.withValue(null)";
                }
            }
            throw new GeaflowRuntimeException(RuntimeErrors.INST.unsupportedError());
        }

        public void addEdgeFormula(String code) {
            this.edgeFormulas.add(code);
        }

        public void addVertexFormula(String code) {
            this.vertexFormulas.add(code);
        }

        public void addEdgePreCompute(PushDownPb.FilterType type) {
            this.edgePreFields.add(type);
        }

        public void addVertexPreCompute(PushDownPb.FilterType type) {
            this.vertexPreFields.add(type);
        }

        public void doAnd() {
            this.doMerge(this.vertexFormulas, " && ");
            this.doMerge(this.edgeFormulas, " && ");
            this.doMerge(this.oneDegreeFormulas, " && ");
        }

        public void doOr() {
            this.doMerge(this.vertexFormulas, " || ");
            this.doMerge(this.edgeFormulas, " || ");
            this.doMerge(this.oneDegreeFormulas, " || ");
        }

        private void doMerge(List<String> formulas, String logic) {
            if (formulas.size() <= 1) {
                return;
            }
            StringBuilder mergedFormula = new StringBuilder();
            for (String formula : formulas) {
                mergedFormula.append("(").append(formula).append(")").append(logic);
            }
            formulas.clear();
            formulas.add(mergedFormula.substring(0, mergedFormula.length() - logic.length()));
        }

        public String getCode(String className) {
            Preconditions.checkArgument((this.vertexFormulas.size() <= 1 ? 1 : 0) != 0);
            Preconditions.checkArgument((this.edgeFormulas.size() <= 1 ? 1 : 0) != 0);
            String vertexCode = Boolean.TRUE.toString();
            String vertexPreCompute = "";
            if (this.vertexFormulas.size() == 1) {
                StringBuilder preCompute = new StringBuilder();
                for (PushDownPb.FilterType filterType : this.vertexPreFields) {
                    preCompute.append(this.getPreComputeCode(filterType)).append("\n");
                }
                vertexPreCompute = preCompute.toString();
                vertexCode = this.vertexFormulas.get(0);
            }
            String edgeCode = Boolean.TRUE.toString();
            String edgePreCompute = "";
            if (this.edgeFormulas.size() == 1) {
                StringBuilder preCompute = new StringBuilder();
                for (PushDownPb.FilterType filterType : this.edgePreFields) {
                    preCompute.append(this.getPreComputeCode(filterType)).append("\n");
                }
                edgePreCompute = preCompute.toString();
                edgeCode = this.edgeFormulas.get(0);
            }
            String oneDegreeCode = Boolean.TRUE.toString();
            if (this.oneDegreeFormulas.size() == 1) {
                oneDegreeCode = this.edgeFormulas.get(0);
            }
            return String.format(TEMPLATE, className, className, vertexPreCompute, vertexCode, edgePreCompute, edgeCode, oneDegreeCode);
        }

        public void merge(CodeGenContext inContext) {
            this.vertexPreFields.addAll(inContext.vertexPreFields);
            this.edgePreFields.addAll(inContext.edgePreFields);
            Preconditions.checkArgument((inContext.vertexFormulas.size() <= 1 ? 1 : 0) != 0);
            Preconditions.checkArgument((inContext.edgeFormulas.size() <= 1 ? 1 : 0) != 0);
            this.vertexFormulas.addAll(inContext.vertexFormulas);
            this.edgeFormulas.addAll(inContext.edgeFormulas);
        }

        public void addOneDegreeFormula(String formula) {
            this.oneDegreeFormulas.add(formula);
        }
    }
}

