/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.pushdown.inner;

import com.antgroup.geaflow.common.type.IType;
import com.antgroup.geaflow.state.graph.encoder.EdgeAtom;
import com.antgroup.geaflow.state.pushdown.IStatePushDown;
import com.antgroup.geaflow.state.pushdown.filter.IFilter;
import com.antgroup.geaflow.state.pushdown.inner.FilterGenerator;
import com.antgroup.geaflow.state.pushdown.inner.PushDownPb;
import com.antgroup.geaflow.state.pushdown.limit.IEdgeLimit;
import com.antgroup.geaflow.state.pushdown.limit.LimitType;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PushDownPbGenerator {
    private static final byte[] EMPTY = new byte[0];

    public static PushDownPb.PushDown getPushDownPb(IType type, IStatePushDown pushDown) {
        PushDownPb.PushDown.Builder builder = PushDownPb.PushDown.newBuilder();
        if (pushDown.getFilters() == null) {
            builder.setFilterNode(FilterGenerator.getFilterData(pushDown.getFilter()));
        } else {
            ArrayList<ByteString> keys = new ArrayList<ByteString>(pushDown.getFilters().size());
            ArrayList<PushDownPb.FilterNode> filterNodes = new ArrayList<PushDownPb.FilterNode>(pushDown.getFilters().size());
            Iterator iterator = pushDown.getFilters().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry obj;
                Map.Entry entry = obj = iterator.next();
                keys.add(ByteString.copyFrom((byte[])type.serialize(entry.getKey())));
                filterNodes.add(FilterGenerator.getFilterData((IFilter)entry.getValue()));
            }
            PushDownPb.FilterNodes nodes = PushDownPb.FilterNodes.newBuilder().addAllKeys(keys).addAllFilterNodes(filterNodes).build();
            builder.setFilterNodes(nodes);
        }
        IEdgeLimit limit = pushDown.getEdgeLimit();
        if (limit != null) {
            builder.setEdgeLimit(PushDownPb.EdgeLimit.newBuilder().setIn(limit.inEdgeLimit()).setOut(limit.outEdgeLimit()).setIsSingle(limit.limitType() == LimitType.SINGLE).build());
        }
        if (pushDown.getOrderFields() != null) {
            List<EdgeAtom> edgeAtoms = pushDown.getOrderFields();
            builder.addAllSortType(edgeAtoms.stream().map(EdgeAtom::toPbSortType).collect(Collectors.toList()));
        }
        return builder.build();
    }

    public static byte[] getPushDownPbBytes(IType type, IStatePushDown pushDown) {
        if (pushDown.isEmpty()) {
            return EMPTY;
        }
        return PushDownPbGenerator.getPushDownPb(type, pushDown).toByteArray();
    }
}

