/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.schema;

import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.common.schema.Field;
import com.antgroup.geaflow.common.serialize.ISerializer;
import com.antgroup.geaflow.common.serialize.SerializerFactory;
import com.antgroup.geaflow.common.tuple.Tuple;
import com.antgroup.geaflow.common.type.IType;
import com.antgroup.geaflow.common.type.Types;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.meta.GraphFiledName;
import com.antgroup.geaflow.model.graph.meta.GraphMeta;
import com.antgroup.geaflow.model.graph.meta.IGraphElementMeta;
import com.antgroup.geaflow.model.graph.property.EmptyProperty;
import com.antgroup.geaflow.model.graph.property.IPropertySerializable;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.graph.encoder.EdgeAtom;
import com.antgroup.geaflow.state.graph.encoder.VertexAtom;
import com.google.common.base.Preconditions;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class GraphDataSchema {
    private final IGraphElementMeta vertexMeta;
    private final IGraphElementMeta edgeMeta;
    private final Map<Class, Integer> metaIdMap = new HashMap<Class, Integer>();
    private final Map<Integer, Class> idMetaMap = new HashMap<Integer, Class>();
    private final boolean emptyVertexProperty;
    private final boolean emptyEdgeProperty;
    private Supplier<IVertex> vertexConsFun;
    private Supplier<IEdge> edgeConsFun;
    private Function<Object, byte[]> vertexPropertySerFun;
    private Function<Object, byte[]> edgePropertySerFun;
    private Function<byte[], Object> vertexPropertyDeFun;
    private Function<byte[], Object> edgePropertyDeFun;
    private List<EdgeAtom> edgeAtoms = new ArrayList<EdgeAtom>();
    private List<VertexAtom> vertexAtoms = new ArrayList<VertexAtom>();
    private IType keyType;

    public GraphDataSchema(GraphMeta meta) {
        this.vertexMeta = meta.getVertexMeta();
        this.edgeMeta = meta.getEdgeMeta();
        this.keyType = meta.getKeyType();
        this.emptyVertexProperty = this.vertexMeta.getPropertyClass() == EmptyProperty.class;
        this.emptyEdgeProperty = this.edgeMeta.getPropertyClass() == EmptyProperty.class;
        this.vertexConsFun = Objects.requireNonNull(meta.getVertexMeta().getGraphElementConstruct());
        this.edgeConsFun = Objects.requireNonNull(meta.getEdgeMeta().getGraphElementConstruct());
        this.transform(meta.getVertexMeta());
        this.transform(meta.getEdgeMeta());
    }

    private LinkedHashMap<String, IType> transform(IGraphElementMeta<?> elementMeta) {
        this.metaIdMap.put(elementMeta.getGraphElementClass(), Integer.valueOf(elementMeta.getGraphElementId()));
        this.idMetaMap.put(Integer.valueOf(elementMeta.getGraphElementId()), elementMeta.getGraphElementClass());
        boolean isEdge = IEdge.class.isAssignableFrom(elementMeta.getGraphElementClass());
        LinkedHashMap<String, IType> map = new LinkedHashMap<String, IType>();
        for (Field field : elementMeta.getGraphMeta().getFields()) {
            map.put(field.getName(), field.getType());
            if (isEdge) {
                this.edgeAtoms.add((EdgeAtom)((Object)Preconditions.checkNotNull((Object)((Object)EdgeAtom.EDGE_ATOM_MAP.get(GraphFiledName.valueOf((String)field.getName()))))));
                continue;
            }
            this.vertexAtoms.add((VertexAtom)((Object)Preconditions.checkNotNull((Object)((Object)VertexAtom.VERTEX_ATOM_MAP.get(GraphFiledName.valueOf((String)field.getName()))))));
        }
        Tuple<Function<Object, byte[]>, Function<byte[], Object>> tuple = this.getPropertySerde(elementMeta.getPropertyClass());
        if (isEdge) {
            this.edgePropertySerFun = (Function)tuple.f0;
            this.edgePropertyDeFun = (Function)tuple.f1;
        } else {
            this.vertexPropertySerFun = (Function)tuple.f0;
            this.vertexPropertyDeFun = (Function)tuple.f1;
        }
        return map;
    }

    private Tuple<Function<Object, byte[]>, Function<byte[], Object>> getPropertySerde(Class<?> propertyClass) {
        Function<byte[], Object> deFun;
        Function<Object, byte[]> serFun;
        IType type = Types.getType(propertyClass);
        if (type != null) {
            Function<Object, byte[]> serFun2 = arg_0 -> ((IType)type).serialize(arg_0);
            Function<byte[], Object> deFun2 = arg_0 -> ((IType)type).deserialize(arg_0);
            return Tuple.of(serFun2, deFun2);
        }
        boolean cloneable = IPropertySerializable.class.isAssignableFrom(propertyClass);
        if (cloneable && this.isFinalClass(propertyClass)) {
            IPropertySerializable cleanProperty;
            serFun = o -> ((IPropertySerializable)o).toBytes();
            try {
                cleanProperty = (IPropertySerializable)propertyClass.newInstance();
            }
            catch (Exception e) {
                throw new GeaflowRuntimeException((Throwable)e);
            }
            deFun = bytes -> {
                IPropertySerializable clone = cleanProperty.clone();
                clone.fromBinary(bytes);
                return clone;
            };
        } else {
            ISerializer kryoSerializer = SerializerFactory.getKryoSerializer();
            serFun = arg_0 -> ((ISerializer)kryoSerializer).serialize(arg_0);
            deFun = arg_0 -> ((ISerializer)kryoSerializer).deserialize(arg_0);
        }
        return Tuple.of(serFun, deFun);
    }

    private boolean isFinalClass(Class clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    public Map<Class, Integer> getMetaIdMap() {
        return this.metaIdMap;
    }

    public Map<Integer, Class> getIdMetaMap() {
        return this.idMetaMap;
    }

    public IGraphElementMeta getVertexMeta() {
        return this.vertexMeta;
    }

    public IGraphElementMeta getEdgeMeta() {
        return this.edgeMeta;
    }

    public Supplier<IVertex> getVertexConsFun() {
        return this.vertexConsFun;
    }

    public Supplier<IEdge> getEdgeConsFun() {
        return this.edgeConsFun;
    }

    public Function<Object, byte[]> getVertexPropertySerFun() {
        return this.vertexPropertySerFun;
    }

    public Function<Object, byte[]> getEdgePropertySerFun() {
        return this.edgePropertySerFun;
    }

    public Function<byte[], Object> getVertexPropertyDeFun() {
        return this.vertexPropertyDeFun;
    }

    public Function<byte[], Object> getEdgePropertyDeFun() {
        return this.edgePropertyDeFun;
    }

    public IType getKeyType() {
        return this.keyType;
    }

    public List<EdgeAtom> getEdgeAtoms() {
        return this.edgeAtoms;
    }

    public void setEdgeAtoms(List<EdgeAtom> list) {
        Set edgeFieldSet = this.edgeAtoms.stream().map(EdgeAtom::getGraphFieldName).collect(Collectors.toSet());
        Set newFieldSet = list.stream().map(EdgeAtom::getGraphFieldName).collect(Collectors.toSet());
        Preconditions.checkArgument((boolean)edgeFieldSet.equals(newFieldSet), (String)"edge element not match %s, elements are %s", list, edgeFieldSet);
        this.edgeAtoms = list;
    }

    public List<VertexAtom> getVertexAtoms() {
        return this.vertexAtoms;
    }

    public void setVertexAtoms(List<VertexAtom> list) {
        Set vertexFieldSet = this.vertexAtoms.stream().map(VertexAtom::getGraphFieldName).collect(Collectors.toSet());
        Set newFieldSet = list.stream().map(VertexAtom::getGraphFieldName).collect(Collectors.toSet());
        Preconditions.checkArgument((boolean)vertexFieldSet.equals(newFieldSet), (Object)("illegal vertex order " + list));
        this.vertexAtoms = list;
    }

    public boolean isEmptyVertexProperty() {
        return this.emptyVertexProperty;
    }

    public boolean isEmptyEdgeProperty() {
        return this.emptyEdgeProperty;
    }
}

