/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.serializer;

import com.antgroup.geaflow.common.serialize.ISerializer;
import com.antgroup.geaflow.common.serialize.SerializerFactory;
import com.antgroup.geaflow.common.type.IType;
import com.antgroup.geaflow.common.type.Types;
import com.antgroup.geaflow.state.serializer.IKMapSerializer;
import java.util.function.Function;

public class DefaultKMapSerializer<K, UK, UV>
implements IKMapSerializer<K, UK, UV> {
    private Function<K, byte[]> keySerializer;
    private Function<byte[], K> keyDeserializer;
    private Function<UK, byte[]> subKeySerializer;
    private Function<byte[], UK> subKeyDeserializer;
    private Function<UV, byte[]> valueSerializer;
    private Function<byte[], UV> valueDeserializer;

    public DefaultKMapSerializer(Class<K> keyClazz, Class<UK> subKeyClazz, Class<UV> valueClazz) {
        IType keyType = Types.getType(keyClazz);
        IType subKeyType = Types.getType(subKeyClazz);
        IType valueType = Types.getType(valueClazz);
        ISerializer serializer = SerializerFactory.getKryoSerializer();
        this.keySerializer = keyType == null ? arg_0 -> ((ISerializer)serializer).serialize(arg_0) : arg_0 -> ((IType)keyType).serialize(arg_0);
        Function<byte[], Object> function = this.keyDeserializer = keyType == null ? c -> serializer.deserialize(c) : arg_0 -> ((IType)keyType).deserialize(arg_0);
        this.subKeySerializer = subKeyType == null ? arg_0 -> ((ISerializer)serializer).serialize(arg_0) : arg_0 -> ((IType)subKeyType).serialize(arg_0);
        Function<byte[], Object> function2 = this.subKeyDeserializer = subKeyType == null ? c -> serializer.deserialize(c) : arg_0 -> ((IType)subKeyType).deserialize(arg_0);
        this.valueSerializer = valueType == null ? arg_0 -> ((ISerializer)serializer).serialize(arg_0) : arg_0 -> ((IType)valueType).serialize(arg_0);
        this.valueDeserializer = valueType == null ? c -> serializer.deserialize(c) : arg_0 -> ((IType)valueType).deserialize(arg_0);
    }

    @Override
    public byte[] serializeKey(K key) {
        return this.keySerializer.apply(key);
    }

    @Override
    public K deserializeKey(byte[] array) {
        return this.keyDeserializer.apply(array);
    }

    @Override
    public byte[] serializeUK(UK key) {
        return this.subKeySerializer.apply(key);
    }

    @Override
    public UK deserializeUK(byte[] array) {
        return this.subKeyDeserializer.apply(array);
    }

    @Override
    public byte[] serializeUV(UV value) {
        return this.valueSerializer.apply(value);
    }

    @Override
    public UV deserializeUV(byte[] valueArray) {
        return this.valueDeserializer.apply(valueArray);
    }
}

