/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state;

import com.antgroup.geaflow.state.DynamicQueryableState;
import com.antgroup.geaflow.state.query.QueryCondition;
import com.antgroup.geaflow.state.query.QueryType;
import com.antgroup.geaflow.state.query.QueryableAllGraphState;
import com.antgroup.geaflow.state.query.QueryableAllGraphStateImpl;
import com.antgroup.geaflow.state.query.QueryableKeysGraphState;
import com.antgroup.geaflow.state.query.QueryableKeysGraphStateImpl;
import com.antgroup.geaflow.state.query.QueryableVersionGraphState;
import com.antgroup.geaflow.state.query.QueryableVersionGraphStateImpl;
import com.antgroup.geaflow.state.strategy.manager.IGraphManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class BaseDynamicQueryState<K, VV, EV, R>
implements DynamicQueryableState<K, VV, EV, R> {
    protected final QueryType<R> queryType;
    protected final IGraphManager<K, VV, EV> graphManager;

    public BaseDynamicQueryState(QueryType<R> queryType, IGraphManager<K, VV, EV> graphManager) {
        this.queryType = queryType;
        this.graphManager = graphManager;
    }

    public QueryableAllGraphState<K, VV, EV, R> query(long version) {
        QueryCondition queryCondition = new QueryCondition();
        queryCondition.queryIds = null;
        queryCondition.isFullScan = true;
        return new QueryableAllGraphStateImpl<K, VV, EV, R>(version, this.queryType, this.graphManager, queryCondition);
    }

    public QueryableKeysGraphState<K, VV, EV, R> query(long version, K ... ids) {
        return this.query(version, Arrays.asList(ids));
    }

    public QueryableKeysGraphState<K, VV, EV, R> query(long version, List<K> ids) {
        QueryCondition queryCondition = new QueryCondition();
        queryCondition.queryIds = ids;
        queryCondition.isFullScan = false;
        return new QueryableKeysGraphStateImpl<K, VV, EV, R>(version, this.queryType, this.graphManager, queryCondition);
    }

    public QueryableVersionGraphState<K, VV, EV, R> query(K id) {
        QueryCondition queryCondition = new QueryCondition();
        queryCondition.queryIds = Arrays.asList(id);
        return new QueryableVersionGraphStateImpl<K, VV, EV, R>(this.queryType, this.graphManager, queryCondition);
    }

    public QueryableVersionGraphState<K, VV, EV, R> query(K id, Collection<Long> versions) {
        QueryCondition queryCondition = new QueryCondition();
        queryCondition.queryIds = Arrays.asList(id);
        queryCondition.versions = versions;
        return new QueryableVersionGraphStateImpl<K, VV, EV, R>(this.queryType, this.graphManager, queryCondition);
    }

    public Iterator<K> idIterator() {
        return this.graphManager.getDynamicGraphTrait().vertexIDIterator();
    }
}

