/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state;

import com.antgroup.geaflow.state.BaseKeyStateImpl;
import com.antgroup.geaflow.state.KeyMapState;
import com.antgroup.geaflow.state.context.StateContext;
import com.antgroup.geaflow.state.key.KeyValueTrait;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class KeyValueMapStateImpl<K, UK, UV>
extends BaseKeyStateImpl<K>
implements KeyMapState<K, UK, UV> {
    private final KeyValueTrait<K, Map> kvTrait;

    public KeyValueMapStateImpl(StateContext context) {
        super(context);
        this.kvTrait = this.keyStateManager.getKeyValueTrait(Map.class);
    }

    public Map<UK, UV> get(K key) {
        Map map = (Map)this.kvTrait.get(key);
        return map == null ? new HashMap() : map;
    }

    public List<UV> get(K key, UK ... subKeys) {
        Map<UK, UV> map = this.get(key);
        return Arrays.stream(subKeys).map(map::get).collect(Collectors.toList());
    }

    public void add(K key, UK subKey, UV value) {
        Map<UK, UV> map = this.get(key);
        if (map == null) {
            map = new HashMap<UK, UV>();
        }
        map.put(subKey, value);
        this.add(key, map);
    }

    public void add(K key, Map<UK, UV> map) {
        Map<UK, UV> tmp = this.get(key);
        if (tmp == null) {
            tmp = new HashMap<UK, UV>();
        }
        tmp.putAll(map);
        this.put(key, tmp);
    }

    public void remove(K key) {
        this.kvTrait.remove(key);
    }

    public void put(K key, Map<UK, UV> map) {
        this.kvTrait.put(key, map);
    }

    public void remove(K key, UK ... subKeys) {
        Map<UK, UV> map = this.get(key);
        Arrays.stream(subKeys).forEach(map::remove);
        this.add(key, map);
    }
}

