/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.query;

import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.common.tuple.Tuple;
import com.antgroup.geaflow.state.data.DataType;
import com.antgroup.geaflow.state.graph.encoder.EdgeAtom;
import com.antgroup.geaflow.state.iterator.IteratorWithFn;
import com.antgroup.geaflow.state.iterator.StandardIterator;
import com.antgroup.geaflow.state.pushdown.IStatePushDown;
import com.antgroup.geaflow.state.pushdown.StatePushDown;
import com.antgroup.geaflow.state.pushdown.filter.IFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.FilterHelper;
import com.antgroup.geaflow.state.pushdown.inner.IFilterConverter;
import com.antgroup.geaflow.state.pushdown.limit.ComposedEdgeLimit;
import com.antgroup.geaflow.state.pushdown.limit.SingleEdgeLimit;
import com.antgroup.geaflow.state.pushdown.project.IProjector;
import com.antgroup.geaflow.state.pushdown.project.ProjectType;
import com.antgroup.geaflow.state.query.QueryCondition;
import com.antgroup.geaflow.state.query.QueryType;
import com.antgroup.geaflow.state.query.QueryableGraphState;
import com.antgroup.geaflow.state.strategy.manager.IGraphManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QueryableGraphStateImpl<K, VV, EV, R>
implements QueryableGraphState<K, VV, EV, R> {
    protected final QueryType<R> type;
    protected final IGraphManager<K, VV, EV> graphManager;
    protected IFilterConverter filterConverter;
    protected long version = -1L;
    protected QueryCondition<K> queryCondition;

    public QueryableGraphStateImpl(QueryType<R> type, IGraphManager<K, VV, EV> graphManager) {
        this.type = type;
        this.graphManager = graphManager;
        this.filterConverter = this.graphManager.getFilterConverter();
    }

    public QueryableGraphStateImpl(QueryType<R> type, IGraphManager<K, VV, EV> graphManager, QueryCondition queryCondition) {
        this(type, graphManager);
        this.queryCondition = queryCondition;
    }

    public QueryableGraphStateImpl(Long version, QueryType<R> type, IGraphManager<K, VV, EV> graphManager) {
        this(type, graphManager);
        this.version = version;
    }

    public <U> QueryableGraphState<K, VV, EV, U> select(IProjector<R, U> projector) {
        this.queryCondition.projector = projector;
        if (projector.projectType() == ProjectType.DST_ID || projector.projectType() == ProjectType.TIME) {
            QueryType queryType = new QueryType(DataType.PROJECT_FIELD);
            return new QueryableGraphStateImpl<K, VV, EV, R>(queryType, this.graphManager, this.queryCondition);
        }
        throw new GeaflowRuntimeException(RuntimeErrors.INST.unsupportedError());
    }

    public QueryableGraphState<K, VV, EV, R> limit(long out, long in) {
        boolean isSingleLimit = FilterHelper.isSingleLimit((IFilter[])this.queryCondition.stateFilters);
        this.queryCondition.limit = isSingleLimit ? new SingleEdgeLimit(out, in) : new ComposedEdgeLimit(out, in);
        return this;
    }

    public QueryableGraphState<K, VV, EV, R> orderBy(EdgeAtom atom) {
        this.queryCondition.order = atom;
        return this;
    }

    public List<R> asList() {
        return Lists.newArrayList(this.iterator());
    }

    private Map<K, IFilter> buildMapFilter() {
        HashMap mapFilters = new HashMap(this.queryCondition.stateFilters.length);
        Preconditions.checkArgument((this.queryCondition.stateFilters.length == this.queryCondition.queryIds.size() ? 1 : 0) != 0);
        for (int i = 0; i < this.queryCondition.stateFilters.length; ++i) {
            mapFilters.put(this.queryCondition.queryIds.get(i), this.filterConverter.convert(this.queryCondition.stateFilters[i]));
        }
        return mapFilters;
    }

    protected StatePushDown getPushDown() {
        StatePushDown pushDown = StatePushDown.of().withEdgeLimit(this.queryCondition.limit).withOrderField(this.queryCondition.order);
        if (this.queryCondition.stateFilters.length > 1) {
            pushDown.withFilters(this.buildMapFilter());
        } else {
            pushDown.withFilter(this.filterConverter.convert(this.queryCondition.stateFilters[0]));
        }
        return pushDown;
    }

    private Iterator<R> staticIterator() {
        Iterator it;
        StatePushDown condition = this.getPushDown();
        switch (this.type.getType()) {
            case V: {
                it = this.queryCondition.isFullScan ? this.graphManager.getStaticGraphTrait().getVertexIterator((IStatePushDown)condition) : this.graphManager.getStaticGraphTrait().getVertexIterator(this.queryCondition.queryIds, (IStatePushDown)condition);
                break;
            }
            case E: {
                it = this.queryCondition.isFullScan ? this.graphManager.getStaticGraphTrait().getEdgeIterator((IStatePushDown)condition) : this.graphManager.getStaticGraphTrait().getEdgeIterator(this.queryCondition.queryIds, (IStatePushDown)condition);
                break;
            }
            case VE: {
                it = this.queryCondition.isFullScan ? this.graphManager.getStaticGraphTrait().getOneDegreeGraphIterator((IStatePushDown)condition) : this.graphManager.getStaticGraphTrait().getOneDegreeGraphIterator(this.queryCondition.queryIds, (IStatePushDown)condition);
                break;
            }
            case PROJECT_FIELD: {
                StatePushDown projectCondition = condition.withProjector(this.queryCondition.projector);
                Iterator res = this.queryCondition.isFullScan ? this.graphManager.getStaticGraphTrait().getEdgeProjectIterator((IStatePushDown)projectCondition) : this.graphManager.getStaticGraphTrait().getEdgeProjectIterator(this.queryCondition.queryIds, (IStatePushDown)projectCondition);
                it = new IteratorWithFn(res, Tuple::getF1);
                break;
            }
            default: {
                throw new GeaflowRuntimeException(RuntimeErrors.INST.unsupportedError());
            }
        }
        return it;
    }

    private Iterator<R> dynamicIterator() {
        Iterator it;
        StatePushDown condition = this.getPushDown();
        switch (this.type.getType()) {
            case V: {
                it = this.queryCondition.isFullScan ? this.graphManager.getDynamicGraphTrait().getVertexIterator(this.version, (IStatePushDown)condition) : this.graphManager.getDynamicGraphTrait().getVertexIterator(this.version, this.queryCondition.queryIds, (IStatePushDown)condition);
                break;
            }
            case E: {
                it = this.queryCondition.isFullScan ? this.graphManager.getDynamicGraphTrait().getEdgeIterator(this.version, (IStatePushDown)condition) : this.graphManager.getDynamicGraphTrait().getEdgeIterator(this.version, this.queryCondition.queryIds, (IStatePushDown)condition);
                break;
            }
            case VE: {
                it = this.queryCondition.isFullScan ? this.graphManager.getDynamicGraphTrait().getOneDegreeGraphIterator(this.version, (IStatePushDown)condition) : this.graphManager.getDynamicGraphTrait().getOneDegreeGraphIterator(this.version, this.queryCondition.queryIds, (IStatePushDown)condition);
                break;
            }
            default: {
                throw new GeaflowRuntimeException(RuntimeErrors.INST.unsupportedError());
            }
        }
        return it;
    }

    public Iterator<R> iterator() {
        if (this.queryCondition.isFullScan) {
            Preconditions.checkArgument((this.queryCondition.stateFilters.length <= 1 ? 1 : 0) != 0, (Object)"full scan only support single or none filter now.");
        }
        Iterator<R> it = this.version < 0L ? this.staticIterator() : this.dynamicIterator();
        return new StandardIterator(it);
    }

    public R get() {
        Iterator<R> it = this.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public Map<K, Long> aggregate() {
        Preconditions.checkArgument((this.type.getType() == DataType.E ? 1 : 0) != 0, (Object)"only edge agg is supported now.");
        Preconditions.checkArgument((this.version < 0L ? 1 : 0) != 0, (Object)"only static graph is supported now.");
        Preconditions.checkArgument((this.queryCondition.limit == null ? 1 : 0) != 0, (Object)"limit not supported now.");
        if (this.queryCondition.queryIds != null) {
            Preconditions.checkArgument((this.queryCondition.stateFilters.length == 1 || this.queryCondition.stateFilters.length == this.queryCondition.queryIds.size() ? 1 : 0) != 0, (Object)"filter number must be 1 or equal to key number.");
        }
        StatePushDown condition = this.getPushDown();
        return this.queryCondition.isFullScan ? this.graphManager.getStaticGraphTrait().getAggResult((IStatePushDown)condition) : this.graphManager.getStaticGraphTrait().getAggResult(this.queryCondition.queryIds, (IStatePushDown)condition);
    }
}

