/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.query;

import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.state.data.DataType;
import com.antgroup.geaflow.state.pushdown.IStatePushDown;
import com.antgroup.geaflow.state.pushdown.StatePushDown;
import com.antgroup.geaflow.state.pushdown.filter.IFilter;
import com.antgroup.geaflow.state.pushdown.inner.IFilterConverter;
import com.antgroup.geaflow.state.query.QueryCondition;
import com.antgroup.geaflow.state.query.QueryType;
import com.antgroup.geaflow.state.query.QueryableVersionGraphState;
import com.antgroup.geaflow.state.strategy.manager.IGraphManager;
import com.google.common.base.Preconditions;
import java.util.Map;

public class QueryableVersionGraphStateImpl<K, VV, EV, R>
implements QueryableVersionGraphState<K, VV, EV, R> {
    protected final QueryType<R> type;
    protected final IGraphManager<K, VV, EV> graphManager;
    protected QueryCondition<K> queryCondition;
    protected IFilterConverter filterConverter;

    public QueryableVersionGraphStateImpl(QueryType<R> type, IGraphManager<K, VV, EV> graphManager, QueryCondition<K> queryCondition) {
        this.type = type;
        this.graphManager = graphManager;
        this.queryCondition = queryCondition;
        this.filterConverter = this.graphManager.getFilterConverter();
    }

    public QueryableVersionGraphState<K, VV, EV, R> by(IFilter filter) {
        this.queryCondition.stateFilters[0] = filter;
        return this;
    }

    public Map<Long, R> asMap() {
        Map res;
        Preconditions.checkArgument((this.queryCondition.queryIds.size() == 1 ? 1 : 0) != 0);
        Object id = this.queryCondition.queryIds.iterator().next();
        if (this.type.getType() == DataType.V) {
            res = this.queryCondition.versions != null ? this.graphManager.getDynamicGraphTrait().getVersionData(id, this.queryCondition.versions, (IStatePushDown)StatePushDown.of().withFilter(this.filterConverter.convert(this.queryCondition.stateFilters[0])), DataType.V) : this.graphManager.getDynamicGraphTrait().getAllVersionData(id, (IStatePushDown)StatePushDown.of().withFilter(this.filterConverter.convert(this.queryCondition.stateFilters[0])), DataType.V);
        } else {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.unsupportedError());
        }
        return res;
    }
}

