/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state;

import com.antgroup.geaflow.common.iterator.CloseableIterator;
import com.antgroup.geaflow.state.StaticQueryableState;
import com.antgroup.geaflow.state.query.QueryCondition;
import com.antgroup.geaflow.state.query.QueryType;
import com.antgroup.geaflow.state.query.QueryableAllGraphState;
import com.antgroup.geaflow.state.query.QueryableAllGraphStateImpl;
import com.antgroup.geaflow.state.query.QueryableKeysGraphState;
import com.antgroup.geaflow.state.query.QueryableKeysGraphStateImpl;
import com.antgroup.geaflow.state.query.QueryableOneKeyGraphStateImpl;
import com.antgroup.geaflow.state.strategy.manager.IGraphManager;
import com.antgroup.geaflow.utils.keygroup.KeyGroup;
import java.util.Arrays;
import java.util.List;

public abstract class BaseQueryState<K, VV, EV, R>
implements StaticQueryableState<K, VV, EV, R> {
    protected final QueryType<R> queryType;
    protected final IGraphManager<K, VV, EV> graphManager;

    public BaseQueryState(QueryType<R> queryType, IGraphManager<K, VV, EV> graphManager) {
        this.queryType = queryType;
        this.graphManager = graphManager;
    }

    public QueryableAllGraphState<K, VV, EV, R> query() {
        QueryCondition queryCondition = new QueryCondition();
        queryCondition.queryIds = null;
        queryCondition.isFullScan = true;
        return new QueryableAllGraphStateImpl<K, VV, EV, R>(this.queryType, this.graphManager, queryCondition);
    }

    public QueryableAllGraphState<K, VV, EV, R> query(KeyGroup keyGroup) {
        QueryCondition queryCondition = new QueryCondition();
        queryCondition.keyGroup = keyGroup;
        queryCondition.queryIds = null;
        queryCondition.isFullScan = true;
        return new QueryableAllGraphStateImpl<K, VV, EV, R>(this.queryType, this.graphManager, queryCondition);
    }

    public QueryableKeysGraphState<K, VV, EV, R> query(K id) {
        QueryCondition queryCondition = new QueryCondition();
        queryCondition.queryId = id;
        queryCondition.isFullScan = false;
        return new QueryableOneKeyGraphStateImpl<K, VV, EV, R>(this.queryType, this.graphManager, queryCondition);
    }

    public QueryableKeysGraphState<K, VV, EV, R> query(K ... ids) {
        return this.query(Arrays.asList(ids));
    }

    public QueryableKeysGraphState<K, VV, EV, R> query(List<K> ids) {
        QueryCondition queryCondition = new QueryCondition();
        queryCondition.queryIds = ids;
        queryCondition.isFullScan = false;
        return new QueryableKeysGraphStateImpl<K, VV, EV, R>(this.queryType, this.graphManager, queryCondition);
    }

    public CloseableIterator<K> idIterator() {
        return this.graphManager.getStaticGraphTrait().vertexIDIterator();
    }

    public CloseableIterator<R> iterator() {
        return this.query().iterator();
    }

    public List<R> asList() {
        return this.query().asList();
    }
}

