/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state;

import com.antgroup.geaflow.state.DynamicGraphState;
import com.antgroup.geaflow.state.DynamicGraphStateImpl;
import com.antgroup.geaflow.state.GraphState;
import com.antgroup.geaflow.state.StaticGraphState;
import com.antgroup.geaflow.state.StaticGraphStateImpl;
import com.antgroup.geaflow.state.context.StateContext;
import com.antgroup.geaflow.state.manage.ManageableGraphState;
import com.antgroup.geaflow.state.manage.ManageableGraphStateImpl;
import com.antgroup.geaflow.state.strategy.manager.GraphManagerImpl;
import com.antgroup.geaflow.state.strategy.manager.IGraphManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphStateImpl<K, VV, EV>
implements GraphState<K, VV, EV> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphStateImpl.class);
    private final IGraphManager<K, VV, EV> graphManager = new GraphManagerImpl();
    private final ManageableGraphState manageableGraphState;
    private StaticGraphState<K, VV, EV> staticGraphState;
    private DynamicGraphState<K, VV, EV> dynamicGraphState;

    public GraphStateImpl(StateContext context) {
        LOGGER.info("ThreadId {}, GraphStateImpl initDB", (Object)Thread.currentThread().getId());
        this.graphManager.init(context);
        this.manageableGraphState = new ManageableGraphStateImpl(this.graphManager);
        this.staticGraphState = new StaticGraphStateImpl<K, VV, EV>(this.graphManager);
        this.dynamicGraphState = new DynamicGraphStateImpl<K, VV, EV>(this.graphManager);
    }

    public StaticGraphState<K, VV, EV> staticGraph() {
        return this.staticGraphState;
    }

    public DynamicGraphState<K, VV, EV> dynamicGraph() {
        return this.dynamicGraphState;
    }

    public ManageableGraphState manage() {
        return this.manageableGraphState;
    }
}

