/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.state.DataModel;
import com.antgroup.geaflow.state.GraphState;
import com.antgroup.geaflow.state.GraphStateImpl;
import com.antgroup.geaflow.state.KeyListState;
import com.antgroup.geaflow.state.KeyListStateImpl;
import com.antgroup.geaflow.state.KeyMapState;
import com.antgroup.geaflow.state.KeyMapStateImpl;
import com.antgroup.geaflow.state.KeyValueListStateImpl;
import com.antgroup.geaflow.state.KeyValueMapStateImpl;
import com.antgroup.geaflow.state.KeyValueState;
import com.antgroup.geaflow.state.KeyValueStateImpl;
import com.antgroup.geaflow.state.StoreType;
import com.antgroup.geaflow.state.context.StateContext;
import com.antgroup.geaflow.state.descriptor.GraphStateDescriptor;
import com.antgroup.geaflow.state.descriptor.KeyListStateDescriptor;
import com.antgroup.geaflow.state.descriptor.KeyMapStateDescriptor;
import com.antgroup.geaflow.state.descriptor.KeyValueStateDescriptor;
import com.antgroup.geaflow.state.serializer.DefaultKMapSerializer;
import com.antgroup.geaflow.state.serializer.DefaultKVSerializer;
import com.antgroup.geaflow.state.serializer.IKVSerializer;
import com.antgroup.geaflow.state.serializer.IKeySerializer;
import com.antgroup.geaflow.store.IStoreBuilder;
import com.antgroup.geaflow.store.api.key.StoreBuilderFactory;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StateFactory
implements Serializable {
    private static final List<StoreType> SUPPORTED_KEY_STORE_TYPES = Arrays.asList(StoreType.ROCKSDB, StoreType.MEMORY);
    private static final Map<String, GraphState> GRAPH_STATE_MAP = new ConcurrentHashMap<String, GraphState>();

    public static <K, VV, EV> GraphState<K, VV, EV> buildGraphState(GraphStateDescriptor<K, VV, EV> descriptor, Configuration configuration) {
        if (descriptor.isSingleton()) {
            return GRAPH_STATE_MAP.computeIfAbsent(descriptor.getName(), k -> StateFactory.getGraphState(descriptor, configuration));
        }
        return StateFactory.getGraphState(descriptor, configuration);
    }

    private static <K, VV, EV> GraphState<K, VV, EV> getGraphState(GraphStateDescriptor<K, VV, EV> descriptor, Configuration configuration) {
        if (descriptor.getDateModel() == null) {
            descriptor.withDataModel(DataModel.STATIC_GRAPH);
        }
        return new GraphStateImpl(new StateContext(descriptor, configuration));
    }

    public static <K, V> KeyValueState<K, V> buildKeyValueState(KeyValueStateDescriptor<K, V> descriptor, Configuration configuration) {
        Preconditions.checkArgument((boolean)SUPPORTED_KEY_STORE_TYPES.contains(StoreType.getEnum((String)descriptor.getStoreType())), (String)"only support %s", SUPPORTED_KEY_STORE_TYPES);
        if (descriptor.getKeySerializer() == null) {
            descriptor.withKVSerializer((IKVSerializer)new DefaultKVSerializer(descriptor.getKeyClazz(), descriptor.getValueClazz()));
        }
        descriptor.withDataModel(DataModel.KV);
        return new KeyValueStateImpl(new StateContext(descriptor, configuration));
    }

    public static <K, V> KeyListState<K, V> buildKeyListState(KeyListStateDescriptor<K, V> descriptor, Configuration configuration) {
        Preconditions.checkArgument((boolean)SUPPORTED_KEY_STORE_TYPES.contains(StoreType.getEnum((String)descriptor.getStoreType())), (String)"only support %s", SUPPORTED_KEY_STORE_TYPES);
        String storeType = descriptor.getStoreType();
        IStoreBuilder builder = StoreBuilderFactory.build((String)storeType);
        if (builder.supportedDataModel().contains(DataModel.KList)) {
            if (descriptor.getKeySerializer() == null) {
                descriptor.withKeySerializer((IKeySerializer)new DefaultKVSerializer(descriptor.getKeyClazz(), descriptor.getValueClazz()));
            }
            descriptor.withDataModel(DataModel.KList);
            return new KeyListStateImpl(new StateContext(descriptor, configuration), descriptor.getValueClazz());
        }
        if (descriptor.getKeySerializer() == null) {
            descriptor.withKeySerializer((IKeySerializer)new DefaultKVSerializer(descriptor.getKeyClazz(), List.class));
        }
        descriptor.withDataModel(DataModel.KV);
        return new KeyValueListStateImpl(new StateContext(descriptor, configuration));
    }

    public static <K, UK, UV> KeyMapState<K, UK, UV> buildKeyMapState(KeyMapStateDescriptor<K, UK, UV> descriptor, Configuration configuration) {
        Preconditions.checkArgument((boolean)SUPPORTED_KEY_STORE_TYPES.contains(StoreType.getEnum((String)descriptor.getStoreType())), (String)"only support %s", SUPPORTED_KEY_STORE_TYPES);
        String storeType = descriptor.getStoreType();
        IStoreBuilder builder = StoreBuilderFactory.build((String)storeType);
        if (builder.supportedDataModel().contains(DataModel.KMap)) {
            if (descriptor.getKeySerializer() == null) {
                descriptor.withKeySerializer((IKeySerializer)new DefaultKMapSerializer(descriptor.getKeyClazz(), descriptor.getSubKeyClazz(), descriptor.getValueClazz()));
            }
            descriptor.withDataModel(DataModel.KMap);
            return new KeyMapStateImpl(new StateContext(descriptor, configuration), descriptor.getSubKeyClazz(), descriptor.getValueClazz());
        }
        if (descriptor.getKeySerializer() == null) {
            descriptor.withKeySerializer((IKeySerializer)new DefaultKVSerializer(descriptor.getKeyClazz(), Map.class));
        }
        descriptor.withDataModel(DataModel.KV);
        return new KeyValueMapStateImpl(new StateContext(descriptor, configuration));
    }
}

