/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.manage;

import com.antgroup.geaflow.state.action.ActionRequest;
import com.antgroup.geaflow.state.action.ActionType;
import com.antgroup.geaflow.state.manage.LoadOption;
import com.antgroup.geaflow.state.manage.StateOperator;
import com.antgroup.geaflow.state.strategy.manager.IStateManager;

public class StateOperatorImpl
implements StateOperator {
    private final IStateManager stateManager;
    private long checkpointId;

    public StateOperatorImpl(IStateManager stateManager) {
        this.stateManager = stateManager;
    }

    public void load(LoadOption loadOption) {
        if (loadOption.getCheckPointId() == 0L) {
            loadOption.withCheckpointId(this.checkpointId);
        }
        this.stateManager.doStoreAction(ActionType.LOAD, new ActionRequest((Object)loadOption));
    }

    public void setCheckpointId(long checkpointId) {
        this.checkpointId = checkpointId;
    }

    public void finish() {
        this.stateManager.doStoreAction(ActionType.FINISH, new ActionRequest());
    }

    public void compact() {
        this.stateManager.doStoreAction(ActionType.COMPACT, new ActionRequest());
    }

    public void archive() {
        this.stateManager.doStoreAction(ActionType.ARCHIVE, new ActionRequest((Object)this.checkpointId));
    }

    public void recover() {
        this.stateManager.doStoreAction(ActionType.RECOVER, new ActionRequest((Object)this.checkpointId));
    }

    public void close() {
        this.stateManager.doStoreAction(ActionType.CLOSE, new ActionRequest());
    }

    public void drop() {
        this.stateManager.doStoreAction(ActionType.DROP, new ActionRequest());
    }
}

