/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.strategy.accessor;

import com.antgroup.geaflow.state.action.ActionRequest;
import com.antgroup.geaflow.state.action.ActionType;
import com.antgroup.geaflow.state.action.EmptyAction;
import com.antgroup.geaflow.state.action.IAction;
import com.antgroup.geaflow.state.action.StateActionContext;
import com.antgroup.geaflow.state.context.StateContext;
import com.antgroup.geaflow.state.strategy.accessor.ActionBuilder;
import com.antgroup.geaflow.store.IBaseStore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseActionAccess {
    protected Map<ActionType, IAction> registeredAction = new HashMap<ActionType, IAction>();

    protected abstract List<ActionType> allowActionTypes();

    protected void initAction(IBaseStore baseStore, StateContext stateContext) {
        List<ActionType> allowActionTypes = this.allowActionTypes();
        for (ActionType actionType : ActionType.values()) {
            if (allowActionTypes.contains((Object)actionType)) {
                IAction action = ActionBuilder.build(actionType);
                action.init(new StateActionContext(baseStore, stateContext.getConfig()));
                this.registerAction(action);
                continue;
            }
            this.registerAction(new EmptyAction(actionType));
        }
    }

    public void registerAction(IAction action) {
        if (action != null) {
            this.registeredAction.put(action.getActionType(), action);
        }
    }

    public void doStoreAction(ActionType actionType, ActionRequest request) {
        this.registeredAction.get((Object)actionType).apply(request);
    }
}

