/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.strategy.manager;

import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.state.context.StateContext;
import com.antgroup.geaflow.state.strategy.accessor.IAccessor;
import com.antgroup.geaflow.utils.keygroup.IKeyGroupAssigner;
import com.antgroup.geaflow.utils.keygroup.KeyGroup;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseShardManager<K, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseShardManager.class);
    protected final int totalShardNum;
    protected Map<Integer, T> traitMap;
    protected KeyGroup shardGroup;
    protected IKeyGroupAssigner assigner;
    protected boolean mayScale;

    public BaseShardManager(StateContext context, Map<Integer, IAccessor> accessorMap) {
        this.shardGroup = context.getKeyGroup();
        this.assigner = context.getDescriptor().getAssigner();
        Preconditions.checkArgument((this.assigner != null ? 1 : 0) != 0, (Object)"The assigner must be not null");
        LOGGER.info("key group {}, key group num {}", (Object)this.shardGroup, (Object)this.assigner.getKeyGroupNumber());
        this.mayScale = context.isLocalStore();
        this.totalShardNum = this.assigner.getKeyGroupNumber();
        this.traitMap = new HashMap<Integer, T>(accessorMap.size());
        for (Map.Entry<Integer, IAccessor> entry : accessorMap.entrySet()) {
            this.traitMap.put(entry.getKey(), entry.getValue());
        }
    }

    protected T getTraitByKey(K key) {
        return this.getTraitById(this.assigner.assign(key));
    }

    protected T getTraitById(int keyGroupId) {
        T trait = this.traitMap.get(keyGroupId);
        if (trait == null) {
            throw new GeaflowRuntimeException("we have " + this.traitMap.keySet() + " need keyGroupId " + keyGroupId);
        }
        return trait;
    }
}

