/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.strategy.manager;

import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.context.StateContext;
import com.antgroup.geaflow.state.data.DataType;
import com.antgroup.geaflow.state.data.OneDegreeGraph;
import com.antgroup.geaflow.state.graph.DynamicGraphTrait;
import com.antgroup.geaflow.state.iterator.IteratorWithFilter;
import com.antgroup.geaflow.state.iterator.MultiIterator;
import com.antgroup.geaflow.state.pushdown.IStatePushDown;
import com.antgroup.geaflow.state.strategy.accessor.IAccessor;
import com.antgroup.geaflow.state.strategy.manager.BaseShardManager;
import com.antgroup.geaflow.state.strategy.manager.TriFunction;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DynamicGraphManagerImpl<K, VV, EV>
extends BaseShardManager<K, DynamicGraphTrait<K, VV, EV>>
implements DynamicGraphTrait<K, VV, EV> {
    public DynamicGraphManagerImpl(StateContext context, Map<Integer, IAccessor> accessorMap) {
        super(context, accessorMap);
    }

    public void addEdge(long version, IEdge<K, EV> edge) {
        ((DynamicGraphTrait)this.getTraitByKey(edge.getSrcId())).addEdge(version, edge);
    }

    public List<IEdge<K, EV>> getEdges(long version, K sid, IStatePushDown pushdown) {
        return ((DynamicGraphTrait)this.getTraitByKey(sid)).getEdges(version, sid, pushdown);
    }

    public OneDegreeGraph<K, VV, EV> getOneDegreeGraph(long version, K sid, IStatePushDown pushdown) {
        return ((DynamicGraphTrait)this.getTraitByKey(sid)).getOneDegreeGraph(version, sid, pushdown);
    }

    public void addVertex(long version, IVertex<K, VV> vertex) {
        ((DynamicGraphTrait)this.getTraitByKey(vertex.getId())).addVertex(version, vertex);
    }

    public IVertex<K, VV> getVertex(long version, K sid, IStatePushDown pushdown) {
        return ((DynamicGraphTrait)this.getTraitByKey(sid)).getVertex(version, sid, pushdown);
    }

    public Iterator<K> vertexIDIterator() {
        ArrayList<Iterator<Object>> iterators = new ArrayList<Iterator<Object>>();
        for (Map.Entry entry : this.traitMap.entrySet()) {
            Iterator<Object> iterator = ((DynamicGraphTrait)entry.getValue()).vertexIDIterator();
            iterators.add(this.mayScale ? this.shardFilter(iterator, (Integer)entry.getKey(), k -> k) : iterator);
        }
        return iterators.size() == 1 ? (Iterator)iterators.get(0) : new MultiIterator(iterators.iterator());
    }

    public Iterator<IVertex<K, VV>> getVertexIterator(long version, IStatePushDown pushdown) {
        return this.getIterator(IVertex::getId, pushdown, (DynamicGraphTrait<K, VV, EV> trait, IStatePushDown pushdown1) -> trait.getVertexIterator(version, pushdown1));
    }

    public Iterator<IVertex<K, VV>> getVertexIterator(long version, List<K> keys, IStatePushDown pushdown) {
        return this.getIterator(keys, pushdown, (DynamicGraphTrait<K, VV, EV> trait, List<K> keys1, IStatePushDown pushdown1) -> trait.getVertexIterator(version, keys1, pushdown1));
    }

    public Iterator<IEdge<K, EV>> getEdgeIterator(long version, IStatePushDown pushdown) {
        return this.getIterator(IEdge::getSrcId, pushdown, (DynamicGraphTrait<K, VV, EV> trait, IStatePushDown pushdown1) -> trait.getEdgeIterator(version, pushdown1));
    }

    public Iterator<IEdge<K, EV>> getEdgeIterator(long version, List<K> keys, IStatePushDown pushdown) {
        return this.getIterator(keys, pushdown, (DynamicGraphTrait<K, VV, EV> trait, List<K> keys1, IStatePushDown pushdown1) -> trait.getEdgeIterator(version, keys1, pushdown1));
    }

    public Iterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(long version, IStatePushDown pushdown) {
        return this.getIterator(OneDegreeGraph::getKey, pushdown, (DynamicGraphTrait<K, VV, EV> trait, IStatePushDown pushdown1) -> trait.getOneDegreeGraphIterator(version, pushdown1));
    }

    public Iterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(long version, List<K> keys, IStatePushDown pushdown) {
        return this.getIterator(keys, pushdown, (DynamicGraphTrait<K, VV, EV> trait, List<K> keys1, IStatePushDown pushdown1) -> trait.getOneDegreeGraphIterator(version, keys1, pushdown1));
    }

    private <R> Iterator<R> getIterator(List<K> keys, IStatePushDown pushdown, TriFunction<DynamicGraphTrait<K, VV, EV>, List<K>, IStatePushDown, Iterator<R>> function) {
        ArrayList<Iterator<R>> iterators = new ArrayList<Iterator<R>>();
        Map<Integer, List<K>> keyGroupMap = this.getKeyGroupMap(keys);
        for (Map.Entry<Integer, List<K>> entry : keyGroupMap.entrySet()) {
            Preconditions.checkArgument((entry.getKey() >= this.shardGroup.getStartKeyGroup() && entry.getKey() <= this.shardGroup.getEndKeyGroup() ? 1 : 0) != 0);
            Iterator<R> iterator = function.apply((DynamicGraphTrait<K, VV, EV>)this.getTraitById(entry.getKey()), entry.getValue(), pushdown);
            iterators.add(iterator);
        }
        return iterators.size() == 1 ? (Iterator)iterators.get(0) : new MultiIterator(iterators.iterator());
    }

    private <R> Iterator<R> getIterator(Function<R, K> keyExtractor, IStatePushDown pushdown, BiFunction<DynamicGraphTrait<K, VV, EV>, IStatePushDown, Iterator<R>> function) {
        ArrayList<Iterator<R>> iterators = new ArrayList<Iterator<R>>();
        int startShard = this.shardGroup.getStartKeyGroup();
        int endShard = this.shardGroup.getEndKeyGroup();
        for (Map.Entry entry : this.traitMap.entrySet()) {
            if ((Integer)entry.getKey() < startShard || (Integer)entry.getKey() > endShard) continue;
            Iterator<R> iterator = function.apply((DynamicGraphTrait<K, VV, EV>)entry.getValue(), pushdown);
            iterators.add(this.mayScale ? this.shardFilter(iterator, (Integer)entry.getKey(), keyExtractor) : iterator);
        }
        return iterators.size() == 1 ? (Iterator)iterators.get(0) : new MultiIterator(iterators.iterator());
    }

    public List<Long> getAllVersions(K id, DataType dataType) {
        return ((DynamicGraphTrait)this.getTraitByKey(id)).getAllVersions(id, dataType);
    }

    public long getLatestVersion(K id, DataType dataType) {
        return ((DynamicGraphTrait)this.getTraitByKey(id)).getLatestVersion(id, dataType);
    }

    public Map<Long, IVertex<K, VV>> getAllVersionData(K id, IStatePushDown pushdown, DataType dataType) {
        return ((DynamicGraphTrait)this.getTraitByKey(id)).getAllVersionData(id, pushdown, dataType);
    }

    public Map<Long, IVertex<K, VV>> getVersionData(K id, Collection<Long> versions, IStatePushDown pushdown, DataType dataType) {
        return ((DynamicGraphTrait)this.getTraitByKey(id)).getVersionData(id, versions, pushdown, dataType);
    }

    private <T> Iterator<T> shardFilter(Iterator<T> iterator, int keyGroupId, Function<T, K> keyExtractor) {
        return new IteratorWithFilter(iterator, t -> this.assigner.assign(keyExtractor.apply(t)) == keyGroupId);
    }

    private Map<Integer, List<K>> getKeyGroupMap(Collection<K> keySet) {
        return keySet.stream().collect(Collectors.groupingBy(c -> this.assigner.assign(c)));
    }
}

