/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.strategy.manager;

import com.antgroup.geaflow.state.context.StateContext;
import com.antgroup.geaflow.state.graph.DynamicGraphTrait;
import com.antgroup.geaflow.state.graph.StaticGraphTrait;
import com.antgroup.geaflow.state.pushdown.inner.IFilterConverter;
import com.antgroup.geaflow.state.strategy.accessor.IAccessor;
import com.antgroup.geaflow.state.strategy.manager.BaseStateManager;
import com.antgroup.geaflow.state.strategy.manager.DynamicGraphManagerImpl;
import com.antgroup.geaflow.state.strategy.manager.IGraphManager;
import com.antgroup.geaflow.state.strategy.manager.StaticGraphManagerImpl;
import com.antgroup.geaflow.store.IBaseStore;
import com.antgroup.geaflow.store.api.graph.IPushDownStore;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphManagerImpl<K, VV, EV>
extends BaseStateManager
implements IGraphManager<K, VV, EV> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphManagerImpl.class);
    private StaticGraphTrait<K, VV, EV> staticGraphTrait;
    private DynamicGraphTrait<K, VV, EV> dynamicGraphTrait;
    private IFilterConverter filterConverter;

    @Override
    public void init(StateContext context) {
        IBaseStore store;
        super.init(context);
        if (this.accessorMap.values().size() > 0 && (store = ((IAccessor)this.accessorMap.values().iterator().next()).getStore()) instanceof IPushDownStore) {
            this.filterConverter = ((IPushDownStore)store).getFilterConverter();
        }
    }

    @Override
    public StaticGraphTrait<K, VV, EV> getStaticGraphTrait() {
        if (this.staticGraphTrait == null) {
            this.staticGraphTrait = new StaticGraphManagerImpl(this.context, this.accessorMap);
        }
        return this.staticGraphTrait;
    }

    @Override
    public DynamicGraphTrait<K, VV, EV> getDynamicGraphTrait() {
        if (this.dynamicGraphTrait == null) {
            this.dynamicGraphTrait = new DynamicGraphManagerImpl(this.context, this.accessorMap);
        }
        return this.dynamicGraphTrait;
    }

    @Override
    public IFilterConverter getFilterConverter() {
        return (IFilterConverter)Preconditions.checkNotNull((Object)this.filterConverter);
    }
}

