/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.strategy.manager;

import com.antgroup.geaflow.common.tuple.Tuple;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.context.StateContext;
import com.antgroup.geaflow.state.data.OneDegreeGraph;
import com.antgroup.geaflow.state.graph.StaticGraphTrait;
import com.antgroup.geaflow.state.iterator.IteratorWithFilter;
import com.antgroup.geaflow.state.iterator.MultiIterator;
import com.antgroup.geaflow.state.pushdown.IStatePushDown;
import com.antgroup.geaflow.state.strategy.accessor.IAccessor;
import com.antgroup.geaflow.state.strategy.manager.BaseShardManager;
import com.antgroup.geaflow.state.strategy.manager.TriFunction;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class StaticGraphManagerImpl<K, VV, EV>
extends BaseShardManager<K, StaticGraphTrait<K, VV, EV>>
implements StaticGraphTrait<K, VV, EV> {
    public StaticGraphManagerImpl(StateContext context, Map<Integer, IAccessor> accessorMap) {
        super(context, accessorMap);
    }

    public void addEdge(IEdge<K, EV> edge) {
        ((StaticGraphTrait)this.getTraitByKey(edge.getSrcId())).addEdge(edge);
    }

    public List<IEdge<K, EV>> getEdges(K sid, IStatePushDown pushdown) {
        return ((StaticGraphTrait)this.getTraitByKey(sid)).getEdges(sid, pushdown);
    }

    public OneDegreeGraph<K, VV, EV> getOneDegreeGraph(K sid, IStatePushDown pushdown) {
        return ((StaticGraphTrait)this.getTraitByKey(sid)).getOneDegreeGraph(sid, pushdown);
    }

    public void addVertex(IVertex<K, VV> vertex) {
        ((StaticGraphTrait)this.getTraitByKey(vertex.getId())).addVertex(vertex);
    }

    public IVertex<K, VV> getVertex(K sid, IStatePushDown pushdown) {
        return ((StaticGraphTrait)this.getTraitByKey(sid)).getVertex(sid, pushdown);
    }

    public Iterator<K> vertexIDIterator() {
        ArrayList<Iterator<Object>> iterators = new ArrayList<Iterator<Object>>();
        for (Map.Entry entry : this.traitMap.entrySet()) {
            Iterator<Object> iterator = ((StaticGraphTrait)entry.getValue()).vertexIDIterator();
            iterators.add(this.mayScale ? this.shardFilter(iterator, (Integer)entry.getKey(), k -> k) : iterator);
        }
        return iterators.size() == 1 ? (Iterator)iterators.get(0) : new MultiIterator(iterators.iterator());
    }

    public Iterator<IVertex<K, VV>> getVertexIterator(IStatePushDown pushdown) {
        return this.getIterator(IVertex::getId, pushdown, StaticGraphTrait::getVertexIterator);
    }

    public Iterator<IVertex<K, VV>> getVertexIterator(List<K> keys, IStatePushDown pushdown) {
        return this.getIterator(keys, pushdown, StaticGraphTrait::getVertexIterator);
    }

    public Iterator<IEdge<K, EV>> getEdgeIterator(IStatePushDown pushdown) {
        return this.getIterator(IEdge::getSrcId, pushdown, StaticGraphTrait::getEdgeIterator);
    }

    public Iterator<IEdge<K, EV>> getEdgeIterator(List<K> keys, IStatePushDown pushdown) {
        return this.getIterator(keys, pushdown, StaticGraphTrait::getEdgeIterator);
    }

    public Iterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(IStatePushDown pushdown) {
        return this.getIterator(OneDegreeGraph::getKey, pushdown, StaticGraphTrait::getOneDegreeGraphIterator);
    }

    public Iterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(List<K> keys, IStatePushDown pushdown) {
        return this.getIterator(keys, pushdown, StaticGraphTrait::getOneDegreeGraphIterator);
    }

    public <R> Iterator<Tuple<K, R>> getEdgeProjectIterator(IStatePushDown<K, IEdge<K, EV>, R> pushdown) {
        return this.getIterator(Tuple::getF0, pushdown, (StaticGraphTrait<K, VV, EV> trait, IStatePushDown pushdown1) -> trait.getEdgeProjectIterator(pushdown1));
    }

    public <R> Iterator<Tuple<K, R>> getEdgeProjectIterator(List<K> keys, IStatePushDown<K, IEdge<K, EV>, R> pushdown) {
        return this.getIterator(keys, pushdown, (StaticGraphTrait<K, VV, EV> trait, List<K> keys1, IStatePushDown pushdown1) -> trait.getEdgeProjectIterator(keys1, pushdown1));
    }

    public Map<K, Long> getAggResult(IStatePushDown pushdown) {
        HashMap map = new HashMap();
        for (Map.Entry entry : this.traitMap.entrySet()) {
            map.put(entry.getKey(), ((StaticGraphTrait)entry.getValue()).getAggResult(pushdown));
        }
        HashMap res = new HashMap();
        for (Map.Entry partRes : map.entrySet()) {
            int keyGroupId = (Integer)partRes.getKey();
            for (Map.Entry entry : ((Map)partRes.getValue()).entrySet()) {
                if (keyGroupId != this.assigner.assign(entry.getKey())) continue;
                res.put(entry.getKey(), entry.getValue());
            }
        }
        return res;
    }

    public Map<K, Long> getAggResult(List<K> keys, IStatePushDown pushdown) {
        HashMap res = new HashMap();
        Map<Integer, List<K>> keyGroupMap = this.getKeyGroupMap(keys);
        for (Map.Entry<Integer, List<K>> entry : keyGroupMap.entrySet()) {
            Preconditions.checkArgument((entry.getKey() >= this.shardGroup.getStartKeyGroup() && entry.getKey() <= this.shardGroup.getEndKeyGroup() ? 1 : 0) != 0);
            res.putAll(((StaticGraphTrait)this.getTraitById(entry.getKey())).getAggResult(entry.getValue(), pushdown));
        }
        return res;
    }

    private <R> Iterator<R> getIterator(List<K> keys, IStatePushDown pushdown, TriFunction<StaticGraphTrait<K, VV, EV>, List<K>, IStatePushDown, Iterator<R>> function) {
        ArrayList<Iterator<R>> iterators = new ArrayList<Iterator<R>>();
        Map<Integer, List<K>> keyGroupMap = this.getKeyGroupMap(keys);
        for (Map.Entry<Integer, List<K>> entry : keyGroupMap.entrySet()) {
            Preconditions.checkArgument((entry.getKey() >= this.shardGroup.getStartKeyGroup() && entry.getKey() <= this.shardGroup.getEndKeyGroup() ? 1 : 0) != 0);
            Iterator<R> iterator = function.apply((StaticGraphTrait<K, VV, EV>)this.getTraitById(entry.getKey()), entry.getValue(), pushdown);
            iterators.add(iterator);
        }
        return iterators.size() == 1 ? (Iterator)iterators.get(0) : new MultiIterator(iterators.iterator());
    }

    private <R> Iterator<R> getIterator(Function<R, K> keyExtractor, IStatePushDown pushdown, BiFunction<StaticGraphTrait<K, VV, EV>, IStatePushDown, Iterator<R>> function) {
        ArrayList<Iterator<R>> iterators = new ArrayList<Iterator<R>>();
        int startShard = this.shardGroup.getStartKeyGroup();
        int endShard = this.shardGroup.getEndKeyGroup();
        for (Map.Entry entry : this.traitMap.entrySet()) {
            if ((Integer)entry.getKey() < startShard || (Integer)entry.getKey() > endShard) continue;
            Iterator<R> iterator = function.apply((StaticGraphTrait<K, VV, EV>)entry.getValue(), pushdown);
            iterators.add(this.mayScale ? this.shardFilter(iterator, (Integer)entry.getKey(), keyExtractor) : iterator);
        }
        return iterators.size() == 1 ? (Iterator)iterators.get(0) : new MultiIterator(iterators.iterator());
    }

    private <T> Iterator<T> shardFilter(Iterator<T> iterator, int keyGroupId, Function<T, K> keyExtractor) {
        return new IteratorWithFilter(iterator, t -> this.assigner.assign(keyExtractor.apply(t)) == keyGroupId);
    }

    private Map<Integer, List<K>> getKeyGroupMap(Collection<K> keySet) {
        return keySet.stream().collect(Collectors.groupingBy(c -> this.assigner.assign(c)));
    }
}

