/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.strategy.accessor;

import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.state.DataModel;
import com.antgroup.geaflow.state.graph.StateMode;
import com.antgroup.geaflow.state.strategy.accessor.COWGraphAccessor;
import com.antgroup.geaflow.state.strategy.accessor.IAccessor;
import com.antgroup.geaflow.state.strategy.accessor.RWDynamicGraphAccessor;
import com.antgroup.geaflow.state.strategy.accessor.RWKeyListAccessor;
import com.antgroup.geaflow.state.strategy.accessor.RWKeyMapAccessor;
import com.antgroup.geaflow.state.strategy.accessor.RWKeyValueAccessor;
import com.antgroup.geaflow.state.strategy.accessor.RWStaticGraphAccessor;
import com.antgroup.geaflow.state.strategy.accessor.ReadOnlyDynamicGraphAccessor;
import com.antgroup.geaflow.state.strategy.accessor.ReadOnlyStaticGraphAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessorBuilder {
    public static final Logger LOGGER = LoggerFactory.getLogger(AccessorBuilder.class);

    public static IAccessor getAccessor(DataModel dataModel, StateMode stateMode) {
        switch (dataModel) {
            case STATIC_GRAPH: {
                return AccessorBuilder.getStaticGraphAccessor(stateMode);
            }
            case DYNAMIC_GRAPH: {
                return AccessorBuilder.getDynamicGraphAccessor(stateMode);
            }
            case KV: {
                return AccessorBuilder.getKVAccessor(stateMode);
            }
            case KList: {
                return AccessorBuilder.getKListAccessor(stateMode);
            }
            case KMap: {
                return AccessorBuilder.getKMapAccessor(stateMode);
            }
        }
        throw new GeaflowRuntimeException(RuntimeErrors.INST.unsupportedError());
    }

    private static IAccessor getStaticGraphAccessor(StateMode stateMode) {
        switch (stateMode) {
            case RW: {
                return new RWStaticGraphAccessor();
            }
            case RDONLY: {
                return new ReadOnlyStaticGraphAccessor();
            }
            case COW: {
                return new COWGraphAccessor();
            }
        }
        throw new GeaflowRuntimeException(RuntimeErrors.INST.unsupportedError());
    }

    private static IAccessor getDynamicGraphAccessor(StateMode stateMode) {
        switch (stateMode) {
            case RW: {
                return new RWDynamicGraphAccessor();
            }
            case RDONLY: {
                return new ReadOnlyDynamicGraphAccessor();
            }
        }
        throw new GeaflowRuntimeException(RuntimeErrors.INST.unsupportedError());
    }

    private static IAccessor getKVAccessor(StateMode stateMode) {
        switch (stateMode) {
            case RW: {
                return new RWKeyValueAccessor();
            }
        }
        throw new GeaflowRuntimeException(RuntimeErrors.INST.unsupportedError());
    }

    private static IAccessor getKListAccessor(StateMode stateMode) {
        switch (stateMode) {
            case RW: {
                return new RWKeyListAccessor();
            }
        }
        throw new GeaflowRuntimeException(RuntimeErrors.INST.unsupportedError());
    }

    private static IAccessor getKMapAccessor(StateMode stateMode) {
        switch (stateMode) {
            case RW: {
                return new RWKeyMapAccessor();
            }
        }
        throw new GeaflowRuntimeException(RuntimeErrors.INST.unsupportedError());
    }
}

