/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.strategy.accessor;

import com.antgroup.geaflow.state.action.ActionRequest;
import com.antgroup.geaflow.state.action.ActionType;
import com.antgroup.geaflow.state.action.EmptyAction;
import com.antgroup.geaflow.state.action.IAction;
import com.antgroup.geaflow.state.action.StateActionContext;
import com.antgroup.geaflow.state.context.StateContext;
import com.antgroup.geaflow.state.strategy.accessor.ActionBuilder;
import com.antgroup.geaflow.store.IBaseStore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class BaseActionAccess {
    private Lock lock = new ReentrantLock();
    protected Map<ActionType, IAction> registeredAction = new HashMap<ActionType, IAction>();

    protected abstract List<ActionType> allowActionTypes();

    protected void initAction(IBaseStore baseStore, StateContext stateContext) {
        List<ActionType> allowActionTypes = this.allowActionTypes();
        for (ActionType actionType : this.allowActionTypes()) {
            if (allowActionTypes.contains((Object)actionType)) {
                IAction action = ActionBuilder.build(actionType);
                action.init(new StateActionContext(baseStore, stateContext.getConfig()));
                this.registerAction(action);
                continue;
            }
            this.registerAction(new EmptyAction(actionType));
        }
    }

    public void registerAction(IAction action) {
        if (action != null) {
            this.registeredAction.put(action.getActionType(), action);
        }
    }

    public void doStoreAction(int shard, ActionType actionType, ActionRequest request) {
        request.setShard(shard);
        this.lock.lock();
        this.registeredAction.get((Object)actionType).apply(request);
        this.lock.unlock();
    }
}

