/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.strategy.accessor;

import com.antgroup.geaflow.common.iterator.CloseableIterator;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.DataModel;
import com.antgroup.geaflow.state.action.ActionType;
import com.antgroup.geaflow.state.context.StateContext;
import com.antgroup.geaflow.state.data.DataType;
import com.antgroup.geaflow.state.data.OneDegreeGraph;
import com.antgroup.geaflow.state.descriptor.GraphStateDescriptor;
import com.antgroup.geaflow.state.pushdown.IStatePushDown;
import com.antgroup.geaflow.state.strategy.accessor.BaseActionAccess;
import com.antgroup.geaflow.state.strategy.accessor.DynamicGraphAccessor;
import com.antgroup.geaflow.store.IBaseStore;
import com.antgroup.geaflow.store.IStoreBuilder;
import com.antgroup.geaflow.store.api.graph.IGraphMultiVersionedStore;
import com.antgroup.geaflow.store.context.StoreContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RWDynamicGraphAccessor<K, VV, EV>
extends BaseActionAccess
implements DynamicGraphAccessor<K, VV, EV> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RWDynamicGraphAccessor.class);
    private IGraphMultiVersionedStore<K, VV, EV> graphStore;

    @Override
    public void init(StateContext context, IStoreBuilder storeBuilder) {
        this.graphStore = (IGraphMultiVersionedStore)storeBuilder.getStore(DataModel.DYNAMIC_GRAPH, context.getConfig());
        GraphStateDescriptor desc = (GraphStateDescriptor)context.getDescriptor();
        StoreContext storeContext = new StoreContext(context.getName()).withConfig(context.getConfig()).withMetricGroup(context.getMetricGroup()).withDataSchema(desc.getGraphSchema()).withName(context.getName()).withShardId(context.getShardId());
        this.graphStore.init(storeContext);
        this.initAction((IBaseStore)this.graphStore, context);
    }

    public IGraphMultiVersionedStore<K, VV, EV> getStore() {
        return this.graphStore;
    }

    @Override
    protected List<ActionType> allowActionTypes() {
        return Stream.of(ActionType.values()).collect(Collectors.toList());
    }

    public void addEdge(long version, IEdge<K, EV> edge) {
        this.getStore().addEdge(version, edge);
    }

    public List<IEdge<K, EV>> getEdges(long version, K sid, IStatePushDown pushdown) {
        return this.getStore().getEdges(version, sid, pushdown);
    }

    public OneDegreeGraph<K, VV, EV> getOneDegreeGraph(long version, K sid, IStatePushDown pushdown) {
        return this.getStore().getOneDegreeGraph(version, sid, pushdown);
    }

    public CloseableIterator<K> vertexIDIterator() {
        return this.getStore().vertexIDIterator();
    }

    public CloseableIterator<K> vertexIDIterator(long version, IStatePushDown pushdown) {
        return this.getStore().vertexIDIterator(version, pushdown);
    }

    public void addVertex(long version, IVertex<K, VV> vertex) {
        this.getStore().addVertex(version, vertex);
    }

    public IVertex<K, VV> getVertex(long version, K sid, IStatePushDown pushdown) {
        return this.getStore().getVertex(version, sid, pushdown);
    }

    public CloseableIterator<IVertex<K, VV>> getVertexIterator(long version, IStatePushDown pushdown) {
        return this.getStore().getVertexIterator(version, pushdown);
    }

    public CloseableIterator<IVertex<K, VV>> getVertexIterator(long version, List<K> keys, IStatePushDown pushdown) {
        return this.getStore().getVertexIterator(version, keys, pushdown);
    }

    public CloseableIterator<IEdge<K, EV>> getEdgeIterator(long version, IStatePushDown pushdown) {
        return this.getStore().getEdgeIterator(version, pushdown);
    }

    public CloseableIterator<IEdge<K, EV>> getEdgeIterator(long version, List<K> keys, IStatePushDown pushdown) {
        return this.getStore().getEdgeIterator(version, keys, pushdown);
    }

    public CloseableIterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(long version, IStatePushDown pushdown) {
        return this.getStore().getOneDegreeGraphIterator(version, pushdown);
    }

    public CloseableIterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(long version, List<K> keys, IStatePushDown pushdown) {
        return this.getStore().getOneDegreeGraphIterator(version, keys, pushdown);
    }

    public List<Long> getAllVersions(K id, DataType dataType) {
        return this.getStore().getAllVersions(id, dataType);
    }

    public long getLatestVersion(K id, DataType dataType) {
        return this.getStore().getLatestVersion(id, dataType);
    }

    public Map<Long, IVertex<K, VV>> getAllVersionData(K id, IStatePushDown pushdown, DataType dataType) {
        return this.getStore().getAllVersionData(id, pushdown, dataType);
    }

    public Map<Long, IVertex<K, VV>> getVersionData(K id, Collection<Long> versions, IStatePushDown pushdown, DataType dataType) {
        return this.getStore().getVersionData(id, versions, pushdown, dataType);
    }
}

