/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.strategy.accessor;

import com.antgroup.geaflow.common.iterator.CloseableIterator;
import com.antgroup.geaflow.common.tuple.Tuple;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.DataModel;
import com.antgroup.geaflow.state.action.ActionType;
import com.antgroup.geaflow.state.context.StateContext;
import com.antgroup.geaflow.state.data.OneDegreeGraph;
import com.antgroup.geaflow.state.descriptor.GraphStateDescriptor;
import com.antgroup.geaflow.state.pushdown.IStatePushDown;
import com.antgroup.geaflow.state.strategy.accessor.BaseActionAccess;
import com.antgroup.geaflow.state.strategy.accessor.IStaticGraphAccessor;
import com.antgroup.geaflow.store.IBaseStore;
import com.antgroup.geaflow.store.IStoreBuilder;
import com.antgroup.geaflow.store.api.graph.IGraphStore;
import com.antgroup.geaflow.store.context.StoreContext;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RWStaticGraphAccessor<K, VV, EV>
extends BaseActionAccess
implements IStaticGraphAccessor<K, VV, EV> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RWStaticGraphAccessor.class);
    private IGraphStore<K, VV, EV> graphStore;

    @Override
    public void init(StateContext context, IStoreBuilder storeBuilder) {
        this.graphStore = (IGraphStore)storeBuilder.getStore(DataModel.STATIC_GRAPH, context.getConfig());
        GraphStateDescriptor desc = (GraphStateDescriptor)context.getDescriptor();
        StoreContext storeContext = new StoreContext(context.getName()).withConfig(context.getConfig()).withMetricGroup(context.getMetricGroup()).withDataSchema(desc.getGraphSchema()).withName(context.getName()).withShardId(context.getShardId());
        this.graphStore.init(storeContext);
        this.initAction((IBaseStore)this.graphStore, context);
    }

    public IGraphStore<K, VV, EV> getStore() {
        return this.graphStore;
    }

    @Override
    protected List<ActionType> allowActionTypes() {
        return Stream.of(ActionType.values()).collect(Collectors.toList());
    }

    public void addEdge(IEdge<K, EV> edge) {
        this.getStore().addEdge(edge);
    }

    public List<IEdge<K, EV>> getEdges(K sid, IStatePushDown pushdown) {
        return this.getStore().getEdges(sid, pushdown);
    }

    public OneDegreeGraph<K, VV, EV> getOneDegreeGraph(K sid, IStatePushDown pushdown) {
        return this.getStore().getOneDegreeGraph(sid, pushdown);
    }

    public CloseableIterator<K> vertexIDIterator() {
        return this.getStore().vertexIDIterator();
    }

    public CloseableIterator<K> vertexIDIterator(IStatePushDown pushDown) {
        return this.getStore().vertexIDIterator(pushDown);
    }

    public void addVertex(IVertex<K, VV> vertex) {
        this.getStore().addVertex(vertex);
    }

    public IVertex<K, VV> getVertex(K sid, IStatePushDown pushdown) {
        return this.getStore().getVertex(sid, pushdown);
    }

    public CloseableIterator<IVertex<K, VV>> getVertexIterator(IStatePushDown pushdown) {
        return this.getStore().getVertexIterator(pushdown);
    }

    public CloseableIterator<IVertex<K, VV>> getVertexIterator(List<K> keys, IStatePushDown pushdown) {
        return this.getStore().getVertexIterator(keys, pushdown);
    }

    public CloseableIterator<IEdge<K, EV>> getEdgeIterator(IStatePushDown pushdown) {
        return this.getStore().getEdgeIterator(pushdown);
    }

    public CloseableIterator<IEdge<K, EV>> getEdgeIterator(List<K> keys, IStatePushDown pushdown) {
        return this.getStore().getEdgeIterator(keys, pushdown);
    }

    public CloseableIterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(IStatePushDown pushdown) {
        return this.getStore().getOneDegreeGraphIterator(pushdown);
    }

    public CloseableIterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(List<K> keys, IStatePushDown pushdown) {
        return this.getStore().getOneDegreeGraphIterator(keys, pushdown);
    }

    public <R> CloseableIterator<Tuple<K, R>> getEdgeProjectIterator(IStatePushDown<K, IEdge<K, EV>, R> pushdown) {
        return this.getStore().getEdgeProjectIterator(pushdown);
    }

    public <R> CloseableIterator<Tuple<K, R>> getEdgeProjectIterator(List<K> keys, IStatePushDown<K, IEdge<K, EV>, R> pushdown) {
        return this.getStore().getEdgeProjectIterator(keys, pushdown);
    }

    public Map<K, Long> getAggResult(IStatePushDown pushdown) {
        return this.getStore().getAggResult(pushdown);
    }

    public Map<K, Long> getAggResult(List<K> keys, IStatePushDown pushdown) {
        return this.getStore().getAggResult(keys, pushdown);
    }
}

