/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.strategy.accessor;

import com.antgroup.geaflow.common.config.keys.StateConfigKeys;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.common.utils.SleepUtils;
import com.antgroup.geaflow.common.utils.ThreadUtil;
import com.antgroup.geaflow.state.action.ActionRequest;
import com.antgroup.geaflow.state.action.ActionType;
import com.antgroup.geaflow.state.action.BaseAction;
import com.antgroup.geaflow.state.action.StateActionContext;
import com.antgroup.geaflow.state.action.close.CloseAction;
import com.antgroup.geaflow.state.action.drop.DropAction;
import com.antgroup.geaflow.state.context.StateContext;
import com.antgroup.geaflow.state.descriptor.GraphStateDescriptor;
import com.antgroup.geaflow.state.graph.StateMode;
import com.antgroup.geaflow.state.manage.LoadOption;
import com.antgroup.geaflow.state.strategy.accessor.ReadOnlyStaticGraphAccessor;
import com.antgroup.geaflow.store.IBaseStore;
import com.antgroup.geaflow.store.IStoreBuilder;
import com.antgroup.geaflow.store.context.StoreContext;
import com.antgroup.geaflow.view.meta.ViewMetaBookKeeper;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyGraph<K, VV, EV> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadOnlyGraph.class);
    protected StateContext context;
    protected IStoreBuilder storeBuilder;
    protected ViewMetaBookKeeper viewMetaBookKeeper;
    protected ScheduledExecutorService syncExecutor;
    protected long currentVersion;
    protected Throwable warmupException;
    protected AtomicBoolean initialized;
    protected IBaseStore inUseGraphStore;
    protected IBaseStore latestGraphStore;
    protected IBaseStore lazyCloseGraphStore;
    protected boolean enableRecoverLatestVersion;
    protected boolean enableStateBackgroundSync;
    protected int syncGapMs;

    public void init(StateContext context, IStoreBuilder storeBuilder) {
        Preconditions.checkArgument((context.getStateMode() == StateMode.RDONLY ? 1 : 0) != 0);
        this.context = context;
        this.storeBuilder = storeBuilder;
        this.viewMetaBookKeeper = new ViewMetaBookKeeper(context.getName(), context.getConfig());
        this.enableRecoverLatestVersion = context.getConfig().getBoolean(StateConfigKeys.STATE_RECOVER_LATEST_VERSION_ENABLE);
        this.enableStateBackgroundSync = context.getConfig().getBoolean(StateConfigKeys.STATE_BACKGROUND_SYNC_ENABLE);
        this.syncGapMs = context.getConfig().getInteger(StateConfigKeys.STATE_SYNC_GAP_MS);
        this.initialized = new AtomicBoolean(false);
        if (this.enableStateBackgroundSync) {
            this.enableRecoverLatestVersion = true;
            LOGGER.info("initialize background sync service");
            this.syncExecutor = Executors.newSingleThreadScheduledExecutor(ThreadUtil.namedThreadFactory((boolean)false, (String)(Thread.currentThread().getName() + "read-only-background-sync-" + context.getShardId())));
            this.startStateSyncService();
        }
    }

    protected List<ActionType> allowActionTypes() {
        return Arrays.asList(ActionType.RECOVER, ActionType.LOAD, ActionType.DROP, ActionType.CLOSE);
    }

    public void doStoreAction(int shard, ActionType actionType, ActionRequest request) {
        if (actionType == ActionType.DROP || actionType == ActionType.CLOSE) {
            BaseAction action = actionType == ActionType.DROP ? new DropAction() : new CloseAction();
            StateActionContext stateActionContext = new StateActionContext(this.latestGraphStore, this.context.getConfig());
            action.init(stateActionContext);
            action.apply(request);
            if (this.enableStateBackgroundSync) {
                this.syncExecutor.shutdown();
            }
        }
        if (actionType == ActionType.RECOVER) {
            long version = (Long)request.getRequest();
            if (!this.enableStateBackgroundSync) {
                this.recover(version);
            }
        } else if (actionType == ActionType.LOAD) {
            LOGGER.info("wait async background sync to be finished");
            LoadOption option = (LoadOption)request.getRequest();
            if (option.getKeyGroup() != null && !option.getKeyGroup().contains(shard)) {
                return;
            }
            if (this.enableStateBackgroundSync) {
                while (!this.initialized.get()) {
                    if (this.warmupException != null) {
                        throw new GeaflowRuntimeException("warmup error", this.warmupException);
                    }
                    SleepUtils.sleepMilliSecond((long)1000L);
                }
            } else {
                this.recover(option.getCheckPointId());
            }
        }
    }

    protected void recover(long version) {
        if (this.enableRecoverLatestVersion) {
            try {
                version = this.viewMetaBookKeeper.getLatestViewVersion(this.context.getName());
            }
            catch (Throwable t) {
                throw new GeaflowRuntimeException("failed to get latest version", t);
            }
        }
        if (this.latestGraphStore == null) {
            this.createReadOnlyState(version);
        } else {
            this.updateVersion(version);
        }
    }

    protected void startStateSyncService() {
        this.syncExecutor.scheduleAtFixedRate(() -> {
            try {
                long start = System.currentTimeMillis();
                long latestVersion = this.viewMetaBookKeeper.getLatestViewVersion(this.context.getName());
                Preconditions.checkArgument((latestVersion > 0L ? 1 : 0) != 0);
                if (latestVersion != this.currentVersion) {
                    this.createReadOnlyState(latestVersion);
                    this.currentVersion = latestVersion;
                } else {
                    LOGGER.info("don't need recover, current version {} latest version {}", (Object)this.currentVersion, (Object)latestVersion);
                }
                this.getStore();
                LOGGER.info("background sync finished cost {}", (Object)(System.currentTimeMillis() - start));
                this.initialized.set(true);
            }
            catch (Throwable t) {
                if (!this.initialized.get()) {
                    this.warmupException = t;
                }
                LOGGER.error("background sync error", t);
            }
        }, 0L, this.syncGapMs, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IBaseStore getStore() {
        if (this.enableStateBackgroundSync) {
            if (this.latestGraphStore == this.inUseGraphStore) return this.inUseGraphStore;
            Class<ReadOnlyStaticGraphAccessor> clazz = ReadOnlyStaticGraphAccessor.class;
            synchronized (ReadOnlyStaticGraphAccessor.class) {
                if (this.latestGraphStore == this.inUseGraphStore) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return this.inUseGraphStore;
                }
                if (this.lazyCloseGraphStore != null) {
                    this.lazyCloseGraphStore.close();
                }
                this.lazyCloseGraphStore = this.inUseGraphStore;
                this.inUseGraphStore = this.latestGraphStore;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.inUseGraphStore;
            }
        }
        if (this.latestGraphStore != null) return this.latestGraphStore;
        LOGGER.warn("create graph store is null, shardId {}, keyGroup {}", (Object)this.context.getShardId(), (Object)this.context.getKeyGroup());
        return this.latestGraphStore;
    }

    protected void createReadOnlyState(long version) {
        LOGGER.info("create new read only state, state index {} version {} backend type {}", new Object[]{this.context.getShardId(), version, this.context.getStoreType()});
        IBaseStore graphStoreTmp = this.storeBuilder.getStore(this.context.getDataModel(), this.context.getConfig());
        GraphStateDescriptor desc = (GraphStateDescriptor)this.context.getDescriptor();
        StoreContext storeContext = new StoreContext(this.context.getName()).withConfig(this.context.getConfig()).withMetricGroup(this.context.getMetricGroup()).withDataSchema(desc.getGraphSchema()).withName(this.context.getName()).withShardId(this.context.getShardId());
        graphStoreTmp.init(storeContext);
        graphStoreTmp.recovery(version);
        this.latestGraphStore = graphStoreTmp;
    }

    protected void updateVersion(long version) {
        LOGGER.info("update read only state, state index {} version {}", (Object)this.context.getShardId(), (Object)version);
        this.latestGraphStore.recovery(version);
    }
}

