/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.strategy.manager;

import com.antgroup.geaflow.common.iterator.CloseableIterator;
import com.antgroup.geaflow.common.tuple.Tuple;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.context.StateContext;
import com.antgroup.geaflow.state.data.OneDegreeGraph;
import com.antgroup.geaflow.state.graph.StaticGraphTrait;
import com.antgroup.geaflow.state.iterator.IteratorWithFilter;
import com.antgroup.geaflow.state.iterator.MultiIterator;
import com.antgroup.geaflow.state.pushdown.IStatePushDown;
import com.antgroup.geaflow.state.strategy.accessor.IAccessor;
import com.antgroup.geaflow.state.strategy.manager.BaseShardManager;
import com.antgroup.geaflow.state.strategy.manager.TriFunction;
import com.antgroup.geaflow.utils.keygroup.KeyGroup;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class StaticGraphManagerImpl<K, VV, EV>
extends BaseShardManager<K, StaticGraphTrait<K, VV, EV>>
implements StaticGraphTrait<K, VV, EV> {
    public StaticGraphManagerImpl(StateContext context, Map<Integer, IAccessor> accessorMap) {
        super(context, accessorMap);
    }

    public void addEdge(IEdge<K, EV> edge) {
        ((StaticGraphTrait)this.getTraitByKey(edge.getSrcId())).addEdge(edge);
    }

    public List<IEdge<K, EV>> getEdges(K sid, IStatePushDown pushdown) {
        return ((StaticGraphTrait)this.getTraitByKey(sid)).getEdges(sid, pushdown);
    }

    public OneDegreeGraph<K, VV, EV> getOneDegreeGraph(K sid, IStatePushDown pushdown) {
        return ((StaticGraphTrait)this.getTraitByKey(sid)).getOneDegreeGraph(sid, pushdown);
    }

    public void addVertex(IVertex<K, VV> vertex) {
        ((StaticGraphTrait)this.getTraitByKey(vertex.getId())).addVertex(vertex);
    }

    public IVertex<K, VV> getVertex(K sid, IStatePushDown pushdown) {
        return ((StaticGraphTrait)this.getTraitByKey(sid)).getVertex(sid, pushdown);
    }

    public CloseableIterator<K> vertexIDIterator() {
        ArrayList<CloseableIterator<Object>> iterators = new ArrayList<CloseableIterator<Object>>();
        for (Map.Entry entry : this.traitMap.entrySet()) {
            CloseableIterator<Object> iterator = ((StaticGraphTrait)entry.getValue()).vertexIDIterator();
            iterators.add(this.mayScale ? this.shardFilter(iterator, (Integer)entry.getKey(), k -> k) : iterator);
        }
        return iterators.size() == 1 ? (CloseableIterator)iterators.get(0) : new MultiIterator(iterators.iterator());
    }

    public CloseableIterator<K> vertexIDIterator(IStatePushDown pushdown) {
        ArrayList<CloseableIterator<Object>> iterators = new ArrayList<CloseableIterator<Object>>();
        KeyGroup shardGroup = this.getShardGroup(pushdown);
        for (int shard = shardGroup.getStartKeyGroup(); shard <= shardGroup.getEndKeyGroup(); ++shard) {
            StaticGraphTrait trait = (StaticGraphTrait)this.traitMap.get(shard);
            CloseableIterator<Object> iterator = trait.vertexIDIterator(pushdown);
            iterators.add(this.mayScale ? this.shardFilter(iterator, shard, k -> k) : iterator);
        }
        return iterators.size() == 1 ? (CloseableIterator)iterators.get(0) : new MultiIterator(iterators.iterator());
    }

    public CloseableIterator<IVertex<K, VV>> getVertexIterator(IStatePushDown pushdown) {
        return this.getIterator(IVertex::getId, pushdown, StaticGraphTrait::getVertexIterator);
    }

    public CloseableIterator<IVertex<K, VV>> getVertexIterator(List<K> keys, IStatePushDown pushdown) {
        return this.getIterator(keys, pushdown, StaticGraphTrait::getVertexIterator);
    }

    public CloseableIterator<IEdge<K, EV>> getEdgeIterator(IStatePushDown pushdown) {
        return this.getIterator(IEdge::getSrcId, pushdown, StaticGraphTrait::getEdgeIterator);
    }

    public CloseableIterator<IEdge<K, EV>> getEdgeIterator(List<K> keys, IStatePushDown pushdown) {
        return this.getIterator(keys, pushdown, StaticGraphTrait::getEdgeIterator);
    }

    public CloseableIterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(IStatePushDown pushdown) {
        return this.getIterator(OneDegreeGraph::getKey, pushdown, StaticGraphTrait::getOneDegreeGraphIterator);
    }

    public CloseableIterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(List<K> keys, IStatePushDown pushdown) {
        return this.getIterator(keys, pushdown, StaticGraphTrait::getOneDegreeGraphIterator);
    }

    public <R> CloseableIterator<Tuple<K, R>> getEdgeProjectIterator(IStatePushDown<K, IEdge<K, EV>, R> pushdown) {
        return this.getIterator(Tuple::getF0, pushdown, (StaticGraphTrait<K, VV, EV> trait, IStatePushDown pd) -> trait.getEdgeProjectIterator(pd));
    }

    public <R> CloseableIterator<Tuple<K, R>> getEdgeProjectIterator(List<K> keys, IStatePushDown<K, IEdge<K, EV>, R> pushdown) {
        return this.getIterator(keys, pushdown, (StaticGraphTrait<K, VV, EV> trait, List<K> keys1, IStatePushDown pushdown1) -> trait.getEdgeProjectIterator(keys1, pushdown1));
    }

    public Map<K, Long> getAggResult(IStatePushDown pushdown) {
        HashMap<Integer, Map> map = new HashMap<Integer, Map>();
        KeyGroup shardGroup = this.getShardGroup(pushdown);
        for (int shard = shardGroup.getStartKeyGroup(); shard <= shardGroup.getEndKeyGroup(); ++shard) {
            map.put(shard, ((StaticGraphTrait)this.traitMap.get(shard)).getAggResult(pushdown));
        }
        HashMap res = new HashMap();
        for (Map.Entry partRes : map.entrySet()) {
            int keyGroupId = (Integer)partRes.getKey();
            for (Map.Entry entry : ((Map)partRes.getValue()).entrySet()) {
                if (keyGroupId != this.assigner.assign(entry.getKey())) continue;
                res.put(entry.getKey(), entry.getValue());
            }
        }
        return res;
    }

    public Map<K, Long> getAggResult(List<K> keys, IStatePushDown pushdown) {
        HashMap res = new HashMap();
        Map<Integer, List<K>> keyGroupMap = this.getKeyGroupMap(keys);
        for (Map.Entry<Integer, List<K>> entry : keyGroupMap.entrySet()) {
            Preconditions.checkArgument((entry.getKey() >= this.shardGroup.getStartKeyGroup() && entry.getKey() <= this.shardGroup.getEndKeyGroup() ? 1 : 0) != 0);
            res.putAll(((StaticGraphTrait)this.getTraitById(entry.getKey())).getAggResult(entry.getValue(), pushdown));
        }
        return res;
    }

    private <R> CloseableIterator<R> getIterator(List<K> keys, IStatePushDown pushdown, TriFunction<StaticGraphTrait<K, VV, EV>, List<K>, IStatePushDown, CloseableIterator<R>> function) {
        ArrayList<CloseableIterator<R>> iterators = new ArrayList<CloseableIterator<R>>();
        Map<Integer, List<K>> keyGroupMap = this.getKeyGroupMap(keys);
        for (Map.Entry<Integer, List<K>> entry : keyGroupMap.entrySet()) {
            Preconditions.checkArgument((entry.getKey() >= this.shardGroup.getStartKeyGroup() && entry.getKey() <= this.shardGroup.getEndKeyGroup() ? 1 : 0) != 0);
            CloseableIterator<R> iterator = function.apply((StaticGraphTrait<K, VV, EV>)this.getTraitById(entry.getKey()), entry.getValue(), pushdown);
            iterators.add(iterator);
        }
        return iterators.size() == 1 ? (CloseableIterator)iterators.get(0) : new MultiIterator(iterators.iterator());
    }

    private <R> CloseableIterator<R> getIterator(Function<R, K> keyExtractor, IStatePushDown pushdown, BiFunction<StaticGraphTrait<K, VV, EV>, IStatePushDown, CloseableIterator<R>> function) {
        ArrayList<CloseableIterator<R>> iterators = new ArrayList<CloseableIterator<R>>();
        KeyGroup shardGroup = this.getShardGroup(pushdown);
        int startShard = shardGroup.getStartKeyGroup();
        int endShard = shardGroup.getEndKeyGroup();
        for (int shard = startShard; shard <= endShard; ++shard) {
            StaticGraphTrait trait = (StaticGraphTrait)this.traitMap.get(shard);
            CloseableIterator<R> iterator = function.apply(trait, pushdown);
            iterators.add(this.mayScale ? this.shardFilter(iterator, shard, keyExtractor) : iterator);
        }
        return iterators.size() == 1 ? (CloseableIterator)iterators.get(0) : new MultiIterator(iterators.iterator());
    }

    private <T> CloseableIterator<T> shardFilter(CloseableIterator<T> iterator, int keyGroupId, Function<T, K> keyExtractor) {
        return new IteratorWithFilter(iterator, t -> this.assigner.assign(keyExtractor.apply(t)) == keyGroupId);
    }

    private Map<Integer, List<K>> getKeyGroupMap(Collection<K> keySet) {
        return keySet.stream().collect(Collectors.groupingBy(c -> this.assigner.assign(c)));
    }
}

