/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.stats.collector;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.metric.CycleMetrics;
import com.antgroup.geaflow.common.metric.PipelineMetrics;
import com.antgroup.geaflow.stats.collector.BaseStatsCollector;
import com.antgroup.geaflow.stats.model.StatsMetricType;
import com.antgroup.geaflow.stats.sink.IStatsWriter;

public class PipelineStatsCollector
extends BaseStatsCollector {
    private static final String KEY_SPLIT = "_";

    PipelineStatsCollector(IStatsWriter statsWriter, Configuration configuration) {
        super(statsWriter, configuration);
    }

    public void reportPipelineMetrics(PipelineMetrics pipelineMetric) {
        this.addToWriterQueue(this.genMetricKey(PipelineMetricsType.PIPELINE, pipelineMetric.getName()), pipelineMetric);
    }

    public void reportCycleMetrics(CycleMetrics cycleMetrics) {
        String name = cycleMetrics.getPipelineName() + KEY_SPLIT + cycleMetrics.getName();
        this.addToWriterQueue(this.genMetricKey(PipelineMetricsType.CYCLE, name), cycleMetrics);
    }

    private String genMetricKey(PipelineMetricsType type, String name) {
        return this.jobName + StatsMetricType.Metrics.getValue() + (Object)((Object)type) + KEY_SPLIT + name;
    }

    private static enum PipelineMetricsType {
        PIPELINE,
        CYCLE;

    }
}

