/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.stats.collector;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.stats.collector.ExceptionCollector;
import com.antgroup.geaflow.stats.collector.HeartbeatCollector;
import com.antgroup.geaflow.stats.collector.MetricMetaCollector;
import com.antgroup.geaflow.stats.collector.PipelineStatsCollector;
import com.antgroup.geaflow.stats.collector.ProcessStatsCollector;
import com.antgroup.geaflow.stats.sink.IStatsWriter;
import com.antgroup.geaflow.stats.sink.StatsWriterFactory;

public class StatsCollectorFactory {
    private final ExceptionCollector exceptionCollector;
    private final PipelineStatsCollector pipelineStatsCollector;
    private final ProcessStatsCollector processStatsCollector;
    private final MetricMetaCollector metricMetaCollector;
    private final HeartbeatCollector heartbeatCollector;
    private static StatsCollectorFactory INSTANCE;

    private StatsCollectorFactory(Configuration configuration) {
        IStatsWriter statsWriter = StatsWriterFactory.getStatsWriter(configuration);
        IStatsWriter syncWriter = StatsWriterFactory.getStatsWriter(configuration, true);
        this.exceptionCollector = new ExceptionCollector(syncWriter, configuration);
        this.pipelineStatsCollector = new PipelineStatsCollector(statsWriter, configuration);
        this.metricMetaCollector = new MetricMetaCollector(statsWriter, configuration);
        this.processStatsCollector = new ProcessStatsCollector(configuration);
        this.heartbeatCollector = new HeartbeatCollector(statsWriter, configuration);
    }

    public static synchronized StatsCollectorFactory init(Configuration configuration) {
        if (INSTANCE == null) {
            INSTANCE = new StatsCollectorFactory(configuration);
        }
        return INSTANCE;
    }

    public static StatsCollectorFactory getInstance() {
        return INSTANCE;
    }

    public ExceptionCollector getExceptionCollector() {
        return this.exceptionCollector;
    }

    public PipelineStatsCollector getPipelineStatsCollector() {
        return this.pipelineStatsCollector;
    }

    public HeartbeatCollector getHeartbeatCollector() {
        return this.heartbeatCollector;
    }

    public MetricMetaCollector getMetricMetaCollector() {
        return this.metricMetaCollector;
    }

    public ProcessStatsCollector getProcessStatsCollector() {
        return this.processStatsCollector;
    }
}

