/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.stats.collector;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.utils.ProcessUtil;
import com.antgroup.geaflow.stats.collector.BaseStatsCollector;
import com.antgroup.geaflow.stats.model.EventInfo;
import com.antgroup.geaflow.stats.model.EventLabel;
import com.antgroup.geaflow.stats.model.ExceptionLevel;
import com.antgroup.geaflow.stats.model.StatsMetricType;
import com.antgroup.geaflow.stats.sink.IStatsWriter;

public class EventCollector
extends BaseStatsCollector {
    EventCollector(IStatsWriter statsWriter, Configuration configuration) {
        super(statsWriter, configuration);
    }

    public void reportEvent(ExceptionLevel severityLevel, EventLabel label, String message) {
        this.reportEvent(severityLevel, label.name(), message);
    }

    public void reportEvent(ExceptionLevel severityLevel, String label, String message) {
        EventInfo eventInfo = new EventInfo(ProcessUtil.getHostname(), ProcessUtil.getHostIp(), ProcessUtil.getProcessId(), message, severityLevel.name(), label);
        this.addToWriterQueue(this.genEventKey(), eventInfo);
    }

    private String genEventKey() {
        return this.jobName + StatsMetricType.Event.getValue() + (Long.MAX_VALUE - System.currentTimeMillis());
    }
}

