/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.stats.collector;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.utils.ProcessUtil;
import com.antgroup.geaflow.stats.collector.BaseStatsCollector;
import com.antgroup.geaflow.stats.model.ExceptionInfo;
import com.antgroup.geaflow.stats.model.ExceptionLevel;
import com.antgroup.geaflow.stats.model.StatsMetricType;
import com.antgroup.geaflow.stats.sink.IStatsWriter;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ExceptionCollector
extends BaseStatsCollector {
    ExceptionCollector(IStatsWriter statsWriter, Configuration configuration) {
        super(statsWriter, configuration);
    }

    public void reportException(Throwable e) {
        this.reportException(ExceptionLevel.ERROR, e);
    }

    public void reportException(ExceptionLevel severityLevel, Throwable e) {
        ExceptionInfo log = new ExceptionInfo(ProcessUtil.getHostname(), ProcessUtil.getHostIp(), ProcessUtil.getProcessId(), ExceptionUtils.getStackTrace((Throwable)e), severityLevel.name());
        this.addToWriterQueue(this.genExceptionKey(), log);
    }

    private String genExceptionKey() {
        return this.jobName + StatsMetricType.Exception.getValue() + (Long.MAX_VALUE - System.currentTimeMillis());
    }
}

