/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.stats.collector;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.metric.CycleMetrics;
import com.antgroup.geaflow.common.metric.PipelineMetrics;
import com.antgroup.geaflow.stats.collector.BaseStatsCollector;
import com.antgroup.geaflow.stats.model.MetricCache;
import com.antgroup.geaflow.stats.model.StatsMetricType;
import com.antgroup.geaflow.stats.sink.IStatsWriter;

public class PipelineStatsCollector
extends BaseStatsCollector {
    private static final String KEY_SPLIT = "_";
    private final MetricCache metricCache;

    PipelineStatsCollector(IStatsWriter statsWriter, Configuration configuration, MetricCache metricCache) {
        super(statsWriter, configuration);
        this.metricCache = metricCache;
    }

    public void reportPipelineMetrics(PipelineMetrics pipelineMetric) {
        this.addToWriterQueue(this.genMetricKey(PipelineMetricsType.PIPELINE, pipelineMetric.getName()), pipelineMetric);
        this.metricCache.addPipelineMetrics(pipelineMetric);
    }

    public void reportCycleMetrics(CycleMetrics cycleMetrics) {
        String name = cycleMetrics.getPipelineName() + KEY_SPLIT + cycleMetrics.getName();
        this.addToWriterQueue(this.genMetricKey(PipelineMetricsType.CYCLE, name), cycleMetrics);
        this.metricCache.addCycleMetrics(cycleMetrics);
    }

    private String genMetricKey(PipelineMetricsType type, String name) {
        return this.jobName + StatsMetricType.Metrics.getValue() + (Object)((Object)type) + KEY_SPLIT + name;
    }

    private static enum PipelineMetricsType {
        PIPELINE,
        CYCLE;

    }
}

