/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.stats.collector;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.metric.ProcessMetrics;
import com.antgroup.geaflow.common.utils.ProcessUtil;
import com.antgroup.geaflow.metrics.common.MetricGroupRegistry;
import com.antgroup.geaflow.metrics.common.MetricNameFormatter;
import com.antgroup.geaflow.metrics.common.api.Counter;
import com.antgroup.geaflow.metrics.common.api.Histogram;
import com.antgroup.geaflow.metrics.common.api.MetricGroup;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProcessStatsCollector {
    private static final List<String> OLD_GEN_COLLECTOR_NAMES = Arrays.asList("MarkSweepCompact", "PS MarkSweep", "ConcurrentMarkSweep", "Garbage collection optimized for short pausetimes Old Collector", "Garbage collection optimized for throughput Old Collector", "Garbage collection optimized for deterministic pausetimes Old Collector", "G1 Old Generation");
    private long preTimeNano = System.nanoTime();
    private long preCpuTimeNano = -1L;
    private Map<Long, Long> threadMap = new ConcurrentHashMap<Long, Long>();
    private final Counter totalUsedHeapMB;
    private final Counter totalMemoryMB;
    private final Histogram usedHeapRatio;
    private final Histogram gcTimeHistogram;
    private final Histogram fgcTimeHistogram;
    private final Histogram fgcCountHistogram;

    ProcessStatsCollector(Configuration configuration) {
        MetricGroupRegistry metricGroupRegistry = MetricGroupRegistry.getInstance((Configuration)configuration);
        MetricGroup metricGroup = metricGroupRegistry.getMetricGroup("system");
        this.totalUsedHeapMB = metricGroup.counter(MetricNameFormatter.totalHeapMetricName());
        this.totalMemoryMB = metricGroup.counter(MetricNameFormatter.totalMemoryMetricName());
        this.usedHeapRatio = metricGroup.histogram(MetricNameFormatter.heapUsageRatioMetricName());
        this.gcTimeHistogram = metricGroup.histogram(MetricNameFormatter.gcTimeMetricName());
        this.fgcTimeHistogram = metricGroup.histogram(MetricNameFormatter.fgcCountMetricName());
        this.fgcCountHistogram = metricGroup.histogram(MetricNameFormatter.fgcTimeMetricName());
    }

    public ProcessMetrics collect() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemory = memoryMXBean.getHeapMemoryUsage();
        long committedMB = heapMemory.getCommitted() / 0x100000L;
        long usedMB = heapMemory.getUsed() / 0x100000L;
        ProcessMetrics workerMetrics = new ProcessMetrics();
        workerMetrics.setHeapCommittedMB(committedMB);
        workerMetrics.setHeapUsedMB(usedMB);
        workerMetrics.setTotalMemoryMB(ProcessUtil.getTotalMemory());
        if (committedMB != 0L) {
            double percentage = Math.round((double)usedMB * 100.0 / (double)committedMB);
            workerMetrics.setHeapUsedRatio(percentage);
        }
        long fgcCount = 0L;
        long fgcTime = 0L;
        long gcTime = 0L;
        long gcCount = 0L;
        List<GarbageCollectorMXBean> mxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gmx : mxBeans) {
            gcCount += gmx.getCollectionCount();
            gcTime += gmx.getCollectionTime();
            if (!OLD_GEN_COLLECTOR_NAMES.contains(gmx.getName())) continue;
            fgcCount += gmx.getCollectionCount();
            fgcTime += gmx.getCollectionTime();
        }
        workerMetrics.setFgcCount(fgcCount);
        workerMetrics.setFgcTime(fgcTime);
        workerMetrics.setGcTime(gcTime);
        workerMetrics.setGcCount(gcCount);
        OperatingSystemMXBean systemMXBean = ManagementFactory.getOperatingSystemMXBean();
        String avgLoad = String.format("%.2f", systemMXBean.getSystemLoadAverage());
        workerMetrics.setAvgLoad(Double.parseDouble(avgLoad));
        int availProcessors = systemMXBean.getAvailableProcessors();
        workerMetrics.setAvailCores(availProcessors);
        double cpuUsage = this.getCpuUsage();
        double avgCpuUsage = cpuUsage / (double)availProcessors;
        workerMetrics.setProcessCpu(Double.parseDouble(String.format("%.2f", avgCpuUsage)));
        workerMetrics.setUsedCores(Double.parseDouble(String.format("%.2f", cpuUsage / 100.0)));
        workerMetrics.setActiveThreads(this.threadMap.size());
        this.uploadMetrics(workerMetrics);
        return workerMetrics;
    }

    private synchronized double getCpuUsage() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long totalTimeNano = 0L;
        HashMap<Long, Long> currentThreadMap = new HashMap<Long, Long>();
        for (long id : threadMXBean.getAllThreadIds()) {
            long threadCpuTime = threadMXBean.getThreadCpuTime(id);
            if (threadCpuTime <= 0L) continue;
            totalTimeNano += threadCpuTime;
            currentThreadMap.put(id, threadCpuTime);
            this.threadMap.remove(id);
        }
        Object object = this.threadMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            totalTimeNano += ((Long)entry.getValue()).longValue();
        }
        this.threadMap.clear();
        this.threadMap = currentThreadMap;
        long curTimeNano = System.nanoTime();
        long usedCpuTime = this.preCpuTimeNano == -1L ? 0L : totalTimeNano - this.preCpuTimeNano;
        long totalPassedTime = curTimeNano - this.preTimeNano;
        this.preTimeNano = curTimeNano;
        this.preCpuTimeNano = totalTimeNano;
        return (double)usedCpuTime * 100.0 / (double)totalPassedTime;
    }

    private void uploadMetrics(ProcessMetrics metrics) {
        this.totalUsedHeapMB.inc(metrics.getHeapUsedMB());
        this.totalMemoryMB.inc(metrics.getTotalMemoryMB());
        this.gcTimeHistogram.update(metrics.getGcTime());
        this.fgcTimeHistogram.update(metrics.getFgcTime());
        this.fgcCountHistogram.update(metrics.getFgcCount());
        this.usedHeapRatio.update((int)metrics.getHeapUsedRatio());
    }
}

