/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.stats.model;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.common.metric.CycleMetrics;
import com.antgroup.geaflow.common.metric.PipelineMetrics;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MetricCache
implements Serializable {
    private static final int DEFAULT_MAX_JOBS = 50;
    private final int maxPipelines;
    private final BoundedHashMap<Long, String> submittedPipelines;
    private Map<String, PipelineMetricCache> pipelineMetricCacheMap;

    public MetricCache() {
        this(50);
    }

    public MetricCache(Configuration configuration) {
        this(configuration.getInteger(ExecutionConfigKeys.METRIC_MAX_CACHED_PIPELINES));
    }

    public MetricCache(int maxSize) {
        this.maxPipelines = maxSize;
        this.submittedPipelines = new BoundedHashMap(maxSize);
        this.pipelineMetricCacheMap = new ConcurrentHashMap<String, PipelineMetricCache>();
    }

    public synchronized void addPipelineMetrics(PipelineMetrics pipelineMetrics) {
        this.submittedPipelines.put(pipelineMetrics.getStartTime(), pipelineMetrics.getName());
        PipelineMetricCache cache = this.pipelineMetricCacheMap.computeIfAbsent(pipelineMetrics.getName(), key -> new PipelineMetricCache());
        cache.updatePipelineMetrics(pipelineMetrics);
        if (this.pipelineMetricCacheMap.size() > this.maxPipelines) {
            this.pipelineMetricCacheMap.keySet().retainAll(this.submittedPipelines.values());
        }
    }

    public synchronized void addCycleMetrics(CycleMetrics cycleMetrics) {
        PipelineMetricCache cache = this.pipelineMetricCacheMap.computeIfAbsent(cycleMetrics.getPipelineName(), key -> new PipelineMetricCache());
        cache.addCycleMetrics(cycleMetrics);
    }

    public Map<String, PipelineMetricCache> getPipelineMetricCaches() {
        return this.pipelineMetricCacheMap;
    }

    private void readObject(ObjectInputStream inputStream) throws ClassNotFoundException, IOException {
        this.pipelineMetricCacheMap = (Map)inputStream.readObject();
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        outputStream.writeObject(this.pipelineMetricCacheMap);
    }

    public void mergeMetricCache(MetricCache metricCache) {
        this.pipelineMetricCacheMap.putAll(metricCache.pipelineMetricCacheMap);
    }

    public void clearAll() {
        this.pipelineMetricCacheMap.clear();
    }

    public static class BoundedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxSize;

        public BoundedHashMap(int capacity) {
            super(capacity, 0.75f, true);
            this.maxSize = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }

    public static class PipelineMetricCache
    implements Serializable {
        private PipelineMetrics pipelineMetrics;
        private Map<String, CycleMetrics> cycleMetricMap = new HashMap<String, CycleMetrics>();

        public void updatePipelineMetrics(PipelineMetrics pipelineMetrics) {
            this.pipelineMetrics = pipelineMetrics;
        }

        public void addCycleMetrics(CycleMetrics cycleMetrics) {
            this.cycleMetricMap.put(cycleMetrics.getName(), cycleMetrics);
        }

        public PipelineMetrics getPipelineMetrics() {
            return this.pipelineMetrics;
        }

        public void setPipelineMetrics(PipelineMetrics pipelineMetrics) {
            this.pipelineMetrics = pipelineMetrics;
        }

        public Map<String, CycleMetrics> getCycleMetricList() {
            return this.cycleMetricMap;
        }

        public void setCycleMetricList(Map<String, CycleMetrics> cycleMetricList) {
            this.cycleMetricMap = cycleMetricList;
        }
    }
}

