/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.stats.sink;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.stats.model.StatsStoreType;
import com.antgroup.geaflow.stats.sink.AsyncKvStoreWriter;
import com.antgroup.geaflow.stats.sink.IStatsWriter;
import com.antgroup.geaflow.stats.sink.MemoryStatsWriter;
import com.antgroup.geaflow.stats.sink.SyncKvStoreWriter;

public class StatsWriterFactory {
    public static IStatsWriter getStatsWriter(Configuration configuration) {
        return StatsWriterFactory.getStatsWriter(configuration, false);
    }

    public static IStatsWriter getStatsWriter(Configuration configuration, boolean isSync) {
        String statStoreType = configuration.getString(ExecutionConfigKeys.STATS_METRIC_STORE_TYPE);
        if (statStoreType.equalsIgnoreCase(StatsStoreType.MEMORY.name())) {
            return new MemoryStatsWriter();
        }
        if (statStoreType.equalsIgnoreCase(StatsStoreType.HBASE.name()) || statStoreType.equalsIgnoreCase(StatsStoreType.JDBC.name())) {
            return isSync ? new SyncKvStoreWriter(configuration) : new AsyncKvStoreWriter(configuration);
        }
        throw new UnsupportedOperationException("unknown stats store type" + statStoreType);
    }
}

