/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.api.key;

import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.store.IStoreBuilder;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public class StoreBuilderFactory {
    private static final Map<String, IStoreBuilder> CONCURRENT_TYPE_MAP = new ConcurrentHashMap<String, IStoreBuilder>();

    public static synchronized IStoreBuilder build(String storeType) {
        if (CONCURRENT_TYPE_MAP.containsKey(storeType)) {
            return CONCURRENT_TYPE_MAP.get(storeType);
        }
        ServiceLoader<IStoreBuilder> serviceLoader = ServiceLoader.load(IStoreBuilder.class);
        for (IStoreBuilder storeBuilder : serviceLoader) {
            if (!storeBuilder.getStoreDesc().name().equalsIgnoreCase(storeType)) continue;
            CONCURRENT_TYPE_MAP.put(storeType, storeBuilder);
            return storeBuilder;
        }
        throw new GeaflowRuntimeException(RuntimeErrors.INST.spiNotFoundError(storeType));
    }
}

