/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.context;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.metrics.common.api.MetricGroup;
import com.antgroup.geaflow.state.schema.GraphDataSchema;
import com.antgroup.geaflow.state.serializer.IKeySerializer;
import com.google.common.base.Preconditions;

public class StoreContext {
    private String name;
    private Configuration config;
    private MetricGroup metricGroup;
    private int shardId;
    private long version;
    private GraphDataSchema graphSchema;
    private IKeySerializer keySerializer;

    public StoreContext(String name) {
        this.name = name;
    }

    public StoreContext withConfig(Configuration config) {
        this.config = config;
        return this;
    }

    public StoreContext withShardId(int shardId) {
        this.shardId = shardId;
        return this;
    }

    public StoreContext withMetricGroup(MetricGroup metricGroup) {
        this.metricGroup = metricGroup;
        return this;
    }

    public StoreContext withVersion(long version) {
        this.version = version;
        return this;
    }

    public StoreContext withName(String name) {
        this.name = name;
        return this;
    }

    public StoreContext withDataSchema(GraphDataSchema dataSchema) {
        this.graphSchema = dataSchema;
        return this;
    }

    public StoreContext withKeySerializer(IKeySerializer keySerializer) {
        this.keySerializer = keySerializer;
        return this;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public int getShardId() {
        return this.shardId;
    }

    public MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    public long getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public GraphDataSchema getGraphSchema() {
        return (GraphDataSchema)Preconditions.checkNotNull((Object)this.graphSchema, (Object)"GraphMeta must be set");
    }

    public IKeySerializer getKeySerializer() {
        return this.keySerializer;
    }
}

