/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.data;

import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GraphWriteBuffer<K, VV, EV>
implements Serializable {
    private final int thresholdSize;
    private volatile int size = 0;
    private volatile boolean isFlushing = false;
    private Map<K, List<IEdge<K, EV>>> vertexId2Edges;
    private Map<K, IVertex<K, VV>> vertexId2Vertex;

    public GraphWriteBuffer(int thresholdSize) {
        this.thresholdSize = thresholdSize;
        this.vertexId2Edges = new ConcurrentHashMap<K, List<IEdge<K, EV>>>();
        this.vertexId2Vertex = new ConcurrentHashMap<K, IVertex<K, VV>>();
    }

    public void addVertex(IVertex<K, VV> vertex) {
        this.vertexId2Vertex.put(vertex.getId(), vertex);
        ++this.size;
    }

    public void addEdge(IEdge<K, EV> edge) {
        List list = this.vertexId2Edges.computeIfAbsent(edge.getSrcId(), k -> new ArrayList());
        list.add(edge);
        ++this.size;
    }

    public void addEdges(List<IEdge<K, EV>> edges) {
        if (edges == null || edges.size() == 0) {
            return;
        }
        List list = this.vertexId2Edges.computeIfAbsent(edges.get(0).getSrcId(), k -> new ArrayList());
        list.addAll(edges);
        this.size += edges.size();
    }

    public void setFlushing() {
        this.isFlushing = true;
    }

    public boolean isFlushing() {
        return this.isFlushing;
    }

    public boolean needFlush() {
        return this.size > this.thresholdSize;
    }

    public int getSize() {
        return this.size;
    }

    public Map<K, List<IEdge<K, EV>>> getVertexId2Edges() {
        return this.vertexId2Edges;
    }

    public Map<K, IVertex<K, VV>> getVertexId2Vertex() {
        return this.vertexId2Vertex;
    }

    public void clear() {
        this.vertexId2Vertex.clear();
        this.vertexId2Edges.clear();
        this.size = 0;
        this.isFlushing = false;
    }
}

