/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.data;

import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GraphWriteMultiVersionedBuffer<K, VV, EV>
implements Serializable {
    private final int thresholdSize;
    private volatile int size = 0;
    private volatile boolean isFlushing = false;
    private Map<K, Map<Long, List<IEdge<K, EV>>>> vertexId2Edges;
    private Map<K, Map<Long, IVertex<K, VV>>> vertexId2Vertex;

    public GraphWriteMultiVersionedBuffer(int thresholdSize) {
        this.thresholdSize = thresholdSize;
        this.vertexId2Edges = new ConcurrentHashMap<K, Map<Long, List<IEdge<K, EV>>>>();
        this.vertexId2Vertex = new ConcurrentHashMap<K, Map<Long, IVertex<K, VV>>>();
    }

    public void addEdge(long version, IEdge<K, EV> edge) {
        Object srcId = edge.getSrcId();
        Map map = this.vertexId2Edges.computeIfAbsent(srcId, k -> new HashMap());
        List edges = map.computeIfAbsent(version, k -> new ArrayList());
        edges.add(edge);
        ++this.size;
    }

    public void addVertex(long version, IVertex<K, VV> vertex) {
        Object id = vertex.getId();
        Map map = this.vertexId2Vertex.computeIfAbsent(id, k -> new HashMap());
        map.put(version, vertex);
        ++this.size;
    }

    public IVertex<K, VV> getVertex(long version, K sid) {
        Map<Long, IVertex<K, VV>> map = this.vertexId2Vertex.get(sid);
        IVertex<K, VV> vertex = null;
        if (map != null) {
            vertex = map.get(version);
        }
        return vertex;
    }

    public List<IEdge<K, EV>> getEdges(long version, K sid) {
        Map<Long, List<IEdge<K, EV>>> map = this.vertexId2Edges.get(sid);
        List<Object> list = new ArrayList<IEdge<K, EV>>();
        if (map != null) {
            list = map.getOrDefault(version, new ArrayList());
        }
        return list;
    }

    public Map<K, Map<Long, List<IEdge<K, EV>>>> getVertexId2Edges() {
        return this.vertexId2Edges;
    }

    public Map<K, Map<Long, IVertex<K, VV>>> getVertexId2Vertex() {
        return this.vertexId2Vertex;
    }

    public void setFlushing() {
        this.isFlushing = true;
    }

    public boolean isFlushing() {
        return this.isFlushing;
    }

    public boolean needFlush() {
        return this.size > this.thresholdSize;
    }

    public int getSize() {
        return this.size;
    }

    public void clear() {
        this.vertexId2Vertex.clear();
        this.vertexId2Edges.clear();
        this.size = 0;
        this.isFlushing = false;
    }
}

