/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.iterator;

import com.antgroup.geaflow.common.iterator.CloseableIterator;
import com.antgroup.geaflow.state.pushdown.IStatePushDown;
import com.antgroup.geaflow.state.pushdown.StatePushDown;
import com.antgroup.geaflow.state.pushdown.filter.IFilter;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class KeysIterator<K, VV, EV, R>
implements CloseableIterator<R> {
    private final Iterator<K> iterator;
    private final BiFunction<K, IStatePushDown, R> fetchFun;
    private Function<K, IStatePushDown> pushdownFun;
    private R nextValue;

    public KeysIterator(List<K> keys, BiFunction<K, IStatePushDown, R> fetchFun, IStatePushDown pushdown) {
        this.fetchFun = fetchFun;
        this.iterator = keys.iterator();
        if (pushdown.getFilters() != null) {
            StatePushDown simpleKeyPushDown = StatePushDown.of().withEdgeLimit(pushdown.getEdgeLimit()).withOrderFields(pushdown.getOrderFields());
            this.pushdownFun = k -> simpleKeyPushDown.withFilter((IFilter)pushdown.getFilters().get(k));
        } else {
            this.pushdownFun = k -> pushdown;
        }
    }

    public boolean hasNext() {
        while (this.iterator.hasNext()) {
            K key = this.iterator.next();
            IStatePushDown pushdown = this.pushdownFun.apply(key);
            this.nextValue = this.fetchFun.apply(key, pushdown);
            if (this.nextValue == null) continue;
            return true;
        }
        return false;
    }

    public R next() {
        return this.nextValue;
    }

    public void close() {
    }
}

