/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.jdbc;

import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.common.utils.RetryCommand;
import com.antgroup.geaflow.state.serializer.IKVSerializer;
import com.antgroup.geaflow.store.api.key.IKVStore;
import com.antgroup.geaflow.store.context.StoreContext;
import com.antgroup.geaflow.store.jdbc.BasicJdbcStore;
import com.google.common.base.Preconditions;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcKVStore<K, V>
extends BasicJdbcStore
implements IKVStore<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcKVStore.class);
    private String[] columns = new String[]{"value"};
    private IKVSerializer<K, V> serializer;

    @Override
    public void init(StoreContext storeContext) {
        super.init(storeContext);
        this.serializer = (IKVSerializer)Preconditions.checkNotNull((Object)storeContext.getKeySerializer(), (Object)"keySerializer must be set");
    }

    private String getFromKey(K key) {
        if (key.getClass() == byte[].class) {
            return new String((byte[])key);
        }
        return key.toString();
    }

    public void drop() {
    }

    public V get(K key) {
        try {
            byte[] res = this.query(this.getFromKey(key), this.columns);
            if (res != null) {
                return (V)this.serializer.deserializeValue(res);
            }
            return null;
        }
        catch (SQLException e) {
            throw new GeaflowRuntimeException("get fail", (Throwable)e);
        }
    }

    public void put(K key, V value) {
        byte[] valueArray = this.serializer.serializeValue(value);
        RetryCommand.run(() -> {
            try {
                if (!this.update(this.getFromKey(key), this.columns, new Object[]{valueArray}) && !this.insert(this.getFromKey(key), this.columns, new Object[]{valueArray})) {
                    throw new GeaflowRuntimeException("put fail");
                }
            }
            catch (SQLException e) {
                throw new GeaflowRuntimeException("put fail", (Throwable)e);
            }
            return true;
        }, (int)this.retries);
    }

    public void remove(K key) {
        try {
            this.delete(this.getFromKey(key));
        }
        catch (SQLException e) {
            throw new GeaflowRuntimeException("remove fail", (Throwable)e);
        }
    }
}

