/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.jdbc;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.state.DataModel;
import com.antgroup.geaflow.state.StoreType;
import com.antgroup.geaflow.store.IBaseStore;
import com.antgroup.geaflow.store.IStoreBuilder;
import com.antgroup.geaflow.store.StoreDesc;
import com.antgroup.geaflow.store.jdbc.JdbcKVStore;
import java.util.Arrays;
import java.util.List;

public class JdbcStoreBuilder
implements IStoreBuilder {
    private static final StoreDesc STORE_DESC = new JdbcStoreDesc();

    public IBaseStore getStore(DataModel type, Configuration config) {
        switch (type) {
            case KV: {
                return new JdbcKVStore();
            }
        }
        throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError("not support " + type));
    }

    public StoreDesc getStoreDesc() {
        return STORE_DESC;
    }

    public List<DataModel> supportedDataModel() {
        return Arrays.asList(DataModel.KV);
    }

    public static class JdbcStoreDesc
    implements StoreDesc {
        public boolean isLocalStore() {
            return false;
        }

        public String name() {
            return StoreType.JDBC.name();
        }
    }
}

