/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.redis;

import com.antgroup.geaflow.store.AbstractBaseStore;
import com.antgroup.geaflow.store.IBaseStore;
import com.antgroup.geaflow.store.context.StoreContext;
import com.antgroup.geaflow.store.redis.KVRedisStore;
import com.antgroup.geaflow.store.redis.RedisConfigKeys;
import com.google.common.primitives.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;

public abstract class BaseRedisStore
extends AbstractBaseStore
implements IBaseStore {
    protected static final Logger LOGGER = LoggerFactory.getLogger(KVRedisStore.class);
    protected static final char REDIS_NAMESPACE_SPLITTER = ':';
    protected transient JedisPool jedisPool;
    protected byte[] prefix;
    protected int retryTimes;
    protected int retryIntervalMs;

    public void init(StoreContext storeContext) {
        this.retryTimes = storeContext.getConfig().getInteger(RedisConfigKeys.REDIS_RETRY_TIMES);
        this.retryIntervalMs = storeContext.getConfig().getInteger(RedisConfigKeys.REDIS_RETRY_INTERVAL_MS);
        String host = storeContext.getConfig().getString(RedisConfigKeys.REDIS_HOST);
        int port = storeContext.getConfig().getInteger(RedisConfigKeys.REDIS_PORT);
        LOGGER.info("redis connect {}:{}", (Object)host, (Object)port);
        this.jedisPool = new JedisPool(host, port);
        String prefixStr = storeContext.getName() + ':';
        this.prefix = prefixStr.getBytes();
    }

    protected byte[] getRedisKey(byte[] key) {
        return Bytes.concat((byte[][])new byte[][]{this.prefix, key});
    }

    public void close() {
        this.jedisPool.close();
    }

    public void drop() {
    }
}

