/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.redis;

import com.antgroup.geaflow.common.utils.RetryCommand;
import com.antgroup.geaflow.state.serializer.IKVSerializer;
import com.antgroup.geaflow.store.api.key.IKListStore;
import com.antgroup.geaflow.store.context.StoreContext;
import com.antgroup.geaflow.store.redis.BaseRedisStore;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import redis.clients.jedis.Jedis;

public class KListRedisStore<K, V>
extends BaseRedisStore
implements IKListStore<K, V> {
    private IKVSerializer<K, V> kvSerializer;

    @Override
    public void init(StoreContext storeContext) {
        super.init(storeContext);
        this.kvSerializer = (IKVSerializer)Preconditions.checkNotNull((Object)storeContext.getKeySerializer(), (Object)"kvSerializer must be set");
    }

    public void add(K key, V ... values) {
        byte[] keyArray = this.kvSerializer.serializeKey(key);
        byte[] redisKey = this.getRedisKey(keyArray);
        byte[][] bValues = (byte[][])Arrays.stream(values).map(arg_0 -> this.kvSerializer.serializeValue(arg_0)).toArray(x$0 -> new byte[x$0][]);
        RetryCommand.run(() -> {
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.lpush(redisKey, bValues);
            }
            return null;
        }, (int)this.retryTimes, (long)this.retryIntervalMs);
    }

    public List<V> get(K key) {
        byte[] keyArray = this.kvSerializer.serializeKey(key);
        byte[] redisKey = this.getRedisKey(keyArray);
        List valueArray = (List)RetryCommand.run(() -> {
            try (Jedis jedis = this.jedisPool.getResource();){
                List list = jedis.lrange(redisKey, 0L, -1L);
                return list;
            }
        }, (int)this.retryTimes, (long)this.retryIntervalMs);
        return valueArray.stream().map(arg_0 -> this.kvSerializer.deserializeValue(arg_0)).collect(Collectors.toList());
    }

    public void remove(K key) {
        byte[] keyArray = this.kvSerializer.serializeKey(key);
        byte[] redisKey = this.getRedisKey(keyArray);
        RetryCommand.run(() -> {
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.del(redisKey);
            }
            return null;
        }, (int)this.retryTimes, (long)this.retryIntervalMs);
    }
}

