/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.redis;

import com.antgroup.geaflow.common.utils.RetryCommand;
import com.antgroup.geaflow.state.serializer.IKMapSerializer;
import com.antgroup.geaflow.store.api.key.IKMapStore;
import com.antgroup.geaflow.store.context.StoreContext;
import com.antgroup.geaflow.store.redis.BaseRedisStore;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import redis.clients.jedis.Jedis;

public class KMapRedisStore<K, UK, UV>
extends BaseRedisStore
implements IKMapStore<K, UK, UV> {
    private IKMapSerializer<K, UK, UV> kMapSerializer;

    @Override
    public void init(StoreContext storeContext) {
        super.init(storeContext);
        this.kMapSerializer = (IKMapSerializer)Preconditions.checkNotNull((Object)storeContext.getKeySerializer(), (Object)"keySerializer must be set");
    }

    public void add(K key, Map<UK, UV> value) {
        HashMap<byte[], byte[]> newMap = new HashMap<byte[], byte[]>(value.size());
        for (Map.Entry<UK, UV> entry : value.entrySet()) {
            byte[] ukArray = this.kMapSerializer.serializeUK(entry.getKey());
            byte[] uvArray = this.kMapSerializer.serializeUV(entry.getValue());
            newMap.put(ukArray, uvArray);
        }
        byte[] keyArray = this.kMapSerializer.serializeKey(key);
        byte[] redisKey = this.getRedisKey(keyArray);
        RetryCommand.run(() -> {
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.hset(redisKey, newMap);
            }
            return null;
        }, (int)this.retryTimes, (long)this.retryIntervalMs);
    }

    public void add(K key, UK uk, UV value) {
        byte[] ukArray = this.kMapSerializer.serializeUK(uk);
        byte[] uvArray = this.kMapSerializer.serializeUV(value);
        byte[] keyArray = this.kMapSerializer.serializeKey(key);
        byte[] redisKey = this.getRedisKey(keyArray);
        RetryCommand.run(() -> {
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.hset(redisKey, ukArray, uvArray);
            }
            return null;
        }, (int)this.retryTimes, (long)this.retryIntervalMs);
    }

    public Map<UK, UV> get(K key) {
        byte[] keyArray = this.kMapSerializer.serializeKey(key);
        byte[] redisKey = this.getRedisKey(keyArray);
        Map map = (Map)RetryCommand.run(() -> {
            try (Jedis jedis = this.jedisPool.getResource();){
                Map map = jedis.hgetAll(redisKey);
                return map;
            }
        }, (int)this.retryTimes, (long)this.retryIntervalMs);
        HashMap<Object, Object> newMap = new HashMap<Object, Object>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            newMap.put(this.kMapSerializer.deserializeUK((byte[])entry.getKey()), this.kMapSerializer.deserializeUV((byte[])entry.getValue()));
        }
        return newMap;
    }

    public List<UV> get(K key, UK ... uks) {
        byte[] keyArray = this.kMapSerializer.serializeKey(key);
        byte[] redisKey = this.getRedisKey(keyArray);
        byte[][] ukArray = (byte[][])Arrays.stream(uks).map(arg_0 -> this.kMapSerializer.serializeUK(arg_0)).toArray(x$0 -> new byte[x$0][]);
        List uvArray = (List)RetryCommand.run(() -> {
            try (Jedis jedis = this.jedisPool.getResource();){
                List list = jedis.hmget(redisKey, ukArray);
                return list;
            }
        }, (int)this.retryTimes, (long)this.retryIntervalMs);
        return uvArray.stream().map(arg_0 -> this.kMapSerializer.deserializeUV(arg_0)).collect(Collectors.toList());
    }

    public void remove(K key) {
        byte[] keyArray = this.kMapSerializer.serializeKey(key);
        byte[] redisKey = this.getRedisKey(keyArray);
        RetryCommand.run(() -> {
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.del(redisKey);
            }
            return null;
        }, (int)this.retryTimes, (long)this.retryIntervalMs);
    }

    public void remove(K key, UK ... uks) {
        byte[] keyArray = this.kMapSerializer.serializeKey(key);
        byte[] redisKey = this.getRedisKey(keyArray);
        byte[][] ukArray = (byte[][])Arrays.stream(uks).map(arg_0 -> this.kMapSerializer.serializeUK(arg_0)).toArray(x$0 -> new byte[x$0][]);
        RetryCommand.run(() -> {
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.hdel(redisKey, ukArray);
            }
            return null;
        }, (int)this.retryTimes, (long)this.retryIntervalMs);
    }
}

