/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.redis;

import com.antgroup.geaflow.common.utils.RetryCommand;
import com.antgroup.geaflow.state.serializer.IKVSerializer;
import com.antgroup.geaflow.store.api.key.IKVStore;
import com.antgroup.geaflow.store.context.StoreContext;
import com.antgroup.geaflow.store.redis.BaseRedisStore;
import com.google.common.base.Preconditions;
import redis.clients.jedis.Jedis;

public class KVRedisStore<K, V>
extends BaseRedisStore
implements IKVStore<K, V> {
    private IKVSerializer<K, V> kvSerializer;

    @Override
    public void init(StoreContext storeContext) {
        super.init(storeContext);
        this.kvSerializer = (IKVSerializer)Preconditions.checkNotNull((Object)storeContext.getKeySerializer(), (Object)"keySerializer must be set");
    }

    public void put(K key, V value) {
        byte[] keyArray = this.kvSerializer.serializeKey(key);
        byte[] redisKey = this.getRedisKey(keyArray);
        byte[] valueArray = this.kvSerializer.serializeValue(value);
        RetryCommand.run(() -> {
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.set(redisKey, valueArray);
            }
            return null;
        }, (int)this.retryTimes, (long)this.retryIntervalMs);
    }

    public V get(K key) {
        byte[] keyArray = this.kvSerializer.serializeKey(key);
        byte[] redisKey = this.getRedisKey(keyArray);
        byte[] valueArray = (byte[])RetryCommand.run(() -> {
            try (Jedis jedis = this.jedisPool.getResource();){
                byte[] byArray = jedis.get(redisKey);
                return byArray;
            }
        }, (int)this.retryTimes, (long)this.retryIntervalMs);
        if (valueArray == null) {
            return null;
        }
        return (V)this.kvSerializer.deserializeValue(valueArray);
    }

    public void remove(K key) {
        byte[] keyArray = this.kvSerializer.serializeKey(key);
        byte[] redisKey = this.getRedisKey(keyArray);
        RetryCommand.run(() -> {
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.del(redisKey);
            }
            return null;
        }, (int)this.retryTimes, (long)this.retryIntervalMs);
    }
}

