/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.redis;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.state.DataModel;
import com.antgroup.geaflow.state.StoreType;
import com.antgroup.geaflow.store.IBaseStore;
import com.antgroup.geaflow.store.IStoreBuilder;
import com.antgroup.geaflow.store.StoreDesc;
import com.antgroup.geaflow.store.redis.KListRedisStore;
import com.antgroup.geaflow.store.redis.KMapRedisStore;
import com.antgroup.geaflow.store.redis.KVRedisStore;
import java.util.Arrays;
import java.util.List;

public class RedisStoreBuilder
implements IStoreBuilder {
    private static final StoreDesc STORE_DESC = new RedisStoreDesc();

    public IBaseStore getStore(DataModel type, Configuration config) {
        switch (type) {
            case KV: {
                return new KVRedisStore();
            }
            case KList: {
                return new KListRedisStore();
            }
            case KMap: {
                return new KMapRedisStore();
            }
        }
        throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError("not support " + type));
    }

    public StoreDesc getStoreDesc() {
        return STORE_DESC;
    }

    public List<DataModel> supportedDataModel() {
        return Arrays.asList(DataModel.KV, DataModel.KMap);
    }

    public static class RedisStoreDesc
    implements StoreDesc {
        public boolean isLocalStore() {
            return false;
        }

        public String name() {
            return StoreType.REDIS.name();
        }
    }
}

