/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.rocksdb;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.common.config.keys.FrameworkConfigKeys;
import com.antgroup.geaflow.common.config.keys.StateConfigKeys;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.file.FileConfigKeys;
import com.antgroup.geaflow.store.IBaseStore;
import com.antgroup.geaflow.store.ILocalStore;
import com.antgroup.geaflow.store.context.StoreContext;
import com.antgroup.geaflow.store.rocksdb.RocksdbClient;
import com.antgroup.geaflow.store.rocksdb.RocksdbConfigKeys;
import com.antgroup.geaflow.store.rocksdb.RocksdbPersistClient;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public abstract class BaseRocksdbStore
implements IBaseStore,
ILocalStore {
    protected Configuration config;
    protected String rocksdbPath;
    protected String remotePath;
    protected RocksdbClient rocksdbClient;
    protected RocksdbPersistClient persistClient;
    protected long keepChkNum;
    protected String root;
    protected String jobName;
    protected StoreContext storeContext;
    protected int shardId;

    public void init(StoreContext storeContext) {
        this.storeContext = storeContext;
        this.config = storeContext.getConfig();
        this.shardId = storeContext.getShardId();
        String workerPath = this.config.getString(ExecutionConfigKeys.JOB_WORK_PATH);
        this.jobName = this.config.getString(ExecutionConfigKeys.JOB_APP_NAME);
        this.rocksdbPath = Paths.get(workerPath, this.jobName, storeContext.getName(), Integer.toString(this.shardId)).toString();
        this.root = this.config.getString(FileConfigKeys.ROOT);
        this.remotePath = this.getRemotePath().toString();
        this.persistClient = new RocksdbPersistClient(this.config);
        long chkRate = this.config.getLong(FrameworkConfigKeys.BATCH_NUMBER_PER_CHECKPOINT);
        this.keepChkNum = Math.max((long)this.config.getInteger(StateConfigKeys.STATE_ARCHIVED_VERSION_NUM), chkRate * 2L);
        this.rocksdbClient = new RocksdbClient(this.rocksdbPath, this.getCfList(), this.config);
        this.rocksdbClient.initDB();
    }

    protected abstract List<String> getCfList();

    public void archive(long version) {
        this.flush();
        String chkPath = RocksdbConfigKeys.getChkPath(this.rocksdbPath, version);
        this.rocksdbClient.checkpoint(chkPath);
        try {
            this.persistClient.archive(version, chkPath, this.remotePath, this.keepChkNum);
        }
        catch (Exception e) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.runError("archive fail"), (Throwable)e);
        }
    }

    public void recovery(long version) {
        boolean isScale;
        this.drop();
        String chkPath = RocksdbConfigKeys.getChkPath(this.rocksdbPath, version);
        String recoverPath = this.remotePath;
        boolean bl = isScale = this.shardId != this.storeContext.getShardId();
        if (isScale) {
            recoverPath = this.getRemotePath().toString();
        }
        try {
            this.persistClient.recover(version, this.rocksdbPath, chkPath, recoverPath);
        }
        catch (Exception e) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.runError("recover fail"), (Throwable)e);
        }
        if (isScale) {
            this.persistClient.clearFileInfo();
            this.shardId = this.storeContext.getShardId();
        }
        this.rocksdbClient.initDB();
    }

    protected Path getRemotePath() {
        return Paths.get(this.root, this.jobName, this.storeContext.getName(), Integer.toString(this.shardId));
    }

    public long recoveryLatest() {
        long chkId = this.persistClient.getLatestCheckpointId(this.remotePath);
        if (chkId > 0L) {
            this.recovery(chkId);
        }
        return chkId;
    }

    public void compact() {
        this.rocksdbClient.compact();
    }

    public void flush() {
        this.rocksdbClient.flush();
    }

    public void close() {
        this.rocksdbClient.close();
    }

    public void drop() {
        this.rocksdbClient.drop();
    }

    public void initShardId(int shardId) {
        this.shardId = shardId;
    }
}

