/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.rocksdb;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.data.DataType;
import com.antgroup.geaflow.state.data.OneDegreeGraph;
import com.antgroup.geaflow.state.graph.encoder.GraphKVEncoderFactory;
import com.antgroup.geaflow.state.graph.encoder.IGraphKVEncoder;
import com.antgroup.geaflow.state.pushdown.IStatePushDown;
import com.antgroup.geaflow.state.schema.GraphDataSchema;
import com.antgroup.geaflow.store.api.graph.IGraphMultiVersionedStore;
import com.antgroup.geaflow.store.context.StoreContext;
import com.antgroup.geaflow.store.rocksdb.BaseRocksdbGraphStore;
import com.antgroup.geaflow.store.rocksdb.proxy.IGraphMultiVersionedRocksdbProxy;
import com.antgroup.geaflow.store.rocksdb.proxy.ProxyBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GraphMultiVersionedRocksdbStore<K, VV, EV>
extends BaseRocksdbGraphStore
implements IGraphMultiVersionedStore<K, VV, EV> {
    private IGraphMultiVersionedRocksdbProxy<K, VV, EV> proxy;

    @Override
    public void init(StoreContext storeContext) {
        super.init(storeContext);
        IGraphKVEncoder encoder = GraphKVEncoderFactory.build((Configuration)this.config, (GraphDataSchema)storeContext.getGraphSchema());
        this.proxy = ProxyBuilder.buildMultiVersioned(this.config, this.rocksdbClient, encoder);
    }

    @Override
    protected List<String> getCfList() {
        return Arrays.asList("default", "e", "v_index");
    }

    public void addEdge(long version, IEdge<K, EV> edge) {
        this.proxy.addEdge(version, edge);
    }

    public void addVertex(long version, IVertex<K, VV> vertex) {
        this.proxy.addVertex(version, vertex);
    }

    public IVertex<K, VV> getVertex(long sliceId, K sid, IStatePushDown pushdown) {
        return this.proxy.getVertex(sliceId, sid, pushdown);
    }

    public List<IEdge<K, EV>> getEdges(long sliceId, K sid, IStatePushDown pushdown) {
        return this.proxy.getEdges(sliceId, sid, pushdown);
    }

    public OneDegreeGraph<K, VV, EV> getOneDegreeGraph(long sliceId, K sid, IStatePushDown pushdown) {
        return this.proxy.getOneDegreeGraph(sliceId, sid, pushdown);
    }

    public Iterator<K> vertexIDIterator() {
        return this.proxy.vertexIDIterator();
    }

    public Iterator<IVertex<K, VV>> getVertexIterator(long version, IStatePushDown pushdown) {
        return this.proxy.getVertexIterator(version, pushdown);
    }

    public Iterator<IVertex<K, VV>> getVertexIterator(long version, List<K> keys, IStatePushDown pushdown) {
        return this.proxy.getVertexIterator(version, keys, pushdown);
    }

    public Iterator<IEdge<K, EV>> getEdgeIterator(long version, IStatePushDown pushdown) {
        return this.proxy.getEdgeIterator(version, pushdown);
    }

    public Iterator<IEdge<K, EV>> getEdgeIterator(long version, List<K> keys, IStatePushDown pushdown) {
        return this.proxy.getEdgeIterator(version, keys, pushdown);
    }

    public Iterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(long version, IStatePushDown pushdown) {
        return this.proxy.getOneDegreeGraphIterator(version, pushdown);
    }

    public Iterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(long version, List<K> keys, IStatePushDown pushdown) {
        return this.proxy.getOneDegreeGraphIterator(version, keys, pushdown);
    }

    public List<Long> getAllVersions(K id, DataType dataType) {
        return this.proxy.getAllVersions(id, dataType);
    }

    public long getLatestVersion(K id, DataType dataType) {
        return this.proxy.getLatestVersion(id, dataType);
    }

    public Map<Long, IVertex<K, VV>> getAllVersionData(K id, IStatePushDown pushdown, DataType dataType) {
        return this.proxy.getAllVersionData(id, pushdown, dataType);
    }

    public Map<Long, IVertex<K, VV>> getVersionData(K id, Collection<Long> slices, IStatePushDown pushdown, DataType dataType) {
        return this.proxy.getVersionData(id, slices, pushdown, dataType);
    }

    @Override
    public void flush() {
        this.proxy.flush();
        super.flush();
    }

    @Override
    public void close() {
        this.proxy.close();
        super.close();
    }
}

