/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.rocksdb;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.tuple.Tuple;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.data.OneDegreeGraph;
import com.antgroup.geaflow.state.graph.encoder.EdgeAtom;
import com.antgroup.geaflow.state.graph.encoder.GraphKVEncoderFactory;
import com.antgroup.geaflow.state.graph.encoder.IGraphKVEncoder;
import com.antgroup.geaflow.state.pushdown.IStatePushDown;
import com.antgroup.geaflow.state.schema.GraphDataSchema;
import com.antgroup.geaflow.store.api.graph.IGraphStore;
import com.antgroup.geaflow.store.context.StoreContext;
import com.antgroup.geaflow.store.rocksdb.BaseRocksdbGraphStore;
import com.antgroup.geaflow.store.rocksdb.proxy.IGraphRocksdbProxy;
import com.antgroup.geaflow.store.rocksdb.proxy.ProxyBuilder;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GraphRocksdbStore<K, VV, EV>
extends BaseRocksdbGraphStore
implements IGraphStore<K, VV, EV> {
    private IGraphRocksdbProxy<K, VV, EV> proxy;
    private EdgeAtom sortAtom;

    @Override
    public void init(StoreContext storeContext) {
        super.init(storeContext);
        IGraphKVEncoder encoder = GraphKVEncoderFactory.build((Configuration)this.config, (GraphDataSchema)storeContext.getGraphSchema());
        this.sortAtom = (EdgeAtom)storeContext.getGraphSchema().getEdgeAtoms().get(1);
        this.proxy = ProxyBuilder.build(this.config, this.rocksdbClient, encoder);
    }

    @Override
    protected List<String> getCfList() {
        return Arrays.asList("default", "e");
    }

    public void addEdge(IEdge<K, EV> edge) {
        this.proxy.addEdge(edge);
    }

    public void addVertex(IVertex<K, VV> vertex) {
        this.proxy.addVertex(vertex);
    }

    public IVertex<K, VV> getVertex(K sid, IStatePushDown pushdown) {
        return this.proxy.getVertex(sid, pushdown);
    }

    public List<IEdge<K, EV>> getEdges(K sid, IStatePushDown pushdown) {
        this.checkOrderField(pushdown.getOrderField());
        return this.proxy.getEdges(sid, pushdown);
    }

    public OneDegreeGraph<K, VV, EV> getOneDegreeGraph(K sid, IStatePushDown pushdown) {
        this.checkOrderField(pushdown.getOrderField());
        return this.proxy.getOneDegreeGraph(sid, pushdown);
    }

    public Iterator<K> vertexIDIterator() {
        return this.proxy.vertexIDIterator();
    }

    public Iterator<IVertex<K, VV>> getVertexIterator(IStatePushDown pushdown) {
        return this.proxy.getVertexIterator(pushdown);
    }

    public Iterator<IVertex<K, VV>> getVertexIterator(List<K> keys, IStatePushDown pushdown) {
        return this.proxy.getVertexIterator(keys, pushdown);
    }

    public Iterator<IEdge<K, EV>> getEdgeIterator(IStatePushDown pushdown) {
        this.checkOrderField(pushdown.getOrderField());
        return this.proxy.getEdgeIterator(pushdown);
    }

    public Iterator<IEdge<K, EV>> getEdgeIterator(List<K> keys, IStatePushDown pushdown) {
        this.checkOrderField(pushdown.getOrderField());
        return this.proxy.getEdgeIterator(keys, pushdown);
    }

    public Iterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(IStatePushDown pushdown) {
        this.checkOrderField(pushdown.getOrderField());
        return this.proxy.getOneDegreeGraphIterator(pushdown);
    }

    public Iterator<OneDegreeGraph<K, VV, EV>> getOneDegreeGraphIterator(List<K> keys, IStatePushDown pushdown) {
        this.checkOrderField(pushdown.getOrderField());
        return this.proxy.getOneDegreeGraphIterator(keys, pushdown);
    }

    public <R> Iterator<Tuple<K, R>> getEdgeProjectIterator(IStatePushDown<K, IEdge<K, EV>, R> pushdown) {
        return this.proxy.getEdgeProjectIterator(pushdown);
    }

    public <R> Iterator<Tuple<K, R>> getEdgeProjectIterator(List<K> keys, IStatePushDown<K, IEdge<K, EV>, R> pushdown) {
        return this.proxy.getEdgeProjectIterator(keys, pushdown);
    }

    public Map<K, Long> getAggResult(IStatePushDown pushdown) {
        return this.proxy.getAggResult(pushdown);
    }

    public Map<K, Long> getAggResult(List<K> keys, IStatePushDown pushdown) {
        return this.proxy.getAggResult(keys, pushdown);
    }

    private void checkOrderField(EdgeAtom orderField) {
        Preconditions.checkArgument((orderField == null || this.sortAtom == orderField ? 1 : 0) != 0, (String)"store is sort by %s but need %s", (Object)this.sortAtom, (Object)orderField);
    }

    @Override
    public void flush() {
        this.proxy.flush();
        super.flush();
    }

    @Override
    public void close() {
        this.proxy.close();
        super.close();
    }
}

