/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.rocksdb;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.StateConfigKeys;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.common.tuple.Tuple;
import com.antgroup.geaflow.store.rocksdb.RocksdbConfigKeys;
import com.antgroup.geaflow.store.rocksdb.options.IRocksDBOptions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.rocksdb.Checkpoint;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.TtlDB;
import org.rocksdb.WriteBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksdbClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RocksdbClient.class);
    private final String filePath;
    private final String optionClass;
    private final Configuration config;
    private final List<String> cfList;
    private RocksDB rocksdb;
    private IRocksDBOptions rocksDBOptions;
    private Map<String, ColumnFamilyHandle> handleMap = new HashMap<String, ColumnFamilyHandle>();
    private ArrayList<ColumnFamilyDescriptor> descriptors;

    public RocksdbClient(String filePath, List<String> cfList, Configuration config) {
        this.filePath = filePath;
        this.cfList = cfList;
        this.config = config;
        this.optionClass = this.config.getString(RocksdbConfigKeys.ROCKSDB_OPTION_CLASS);
    }

    private void initRocksDbOptions() {
        if (this.rocksDBOptions == null || this.rocksDBOptions.isClosed()) {
            LOGGER.info("rocksdb optionClass {}", (Object)this.optionClass);
            try {
                this.rocksDBOptions = (IRocksDBOptions)Class.forName(this.optionClass).newInstance();
                this.rocksDBOptions.init(this.config);
            }
            catch (Throwable e) {
                LOGGER.error("{} not found", (Object)this.optionClass);
                throw new GeaflowRuntimeException(RuntimeErrors.INST.runError("class not found"), e);
            }
            if (this.config.getBoolean(RocksdbConfigKeys.ROCKSDB_STATISTICS_ENABLE)) {
                this.rocksDBOptions.enableStatistics();
            }
            if (this.config.getBoolean(StateConfigKeys.STATE_PARANOID_CHECK_ENABLE)) {
                this.rocksDBOptions.enableParanoidCheck();
            }
        }
    }

    public void initDB() {
        File dbFile = new File(this.filePath);
        if (!dbFile.getParentFile().exists()) {
            try {
                FileUtils.forceMkdir((File)dbFile.getParentFile());
            }
            catch (IOException e) {
                throw new GeaflowRuntimeException(RuntimeErrors.INST.runError("create file error"), (Throwable)e);
            }
        }
        if (this.rocksdb == null) {
            this.initRocksDbOptions();
            LOGGER.info("ThreadId {}, buildDB {}", (Object)Thread.currentThread().getId(), (Object)this.filePath);
            int ttl = this.config.getInteger(RocksdbConfigKeys.ROCKSDB_TTL_SECOND);
            this.descriptors = new ArrayList();
            ArrayList handles = new ArrayList();
            ArrayList<Integer> ttls = new ArrayList<Integer>();
            for (String name : this.cfList) {
                this.descriptors.add(new ColumnFamilyDescriptor(name.getBytes(), this.rocksDBOptions.buildFamilyOptions()));
                ttls.add(ttl);
            }
            try {
                this.rocksdb = TtlDB.open((DBOptions)this.rocksDBOptions.getDbOptions(), (String)this.filePath, this.descriptors, handles, ttls, (boolean)false);
            }
            catch (Exception e) {
                throw new GeaflowRuntimeException(RuntimeErrors.INST.runError("open rocksdb error"), (Throwable)e);
            }
            for (int i = 0; i < this.cfList.size(); ++i) {
                this.handleMap.put(this.cfList.get(i), (ColumnFamilyHandle)handles.get(i));
            }
        }
    }

    public Map<String, ColumnFamilyHandle> getColumnFamilyHandleMap() {
        return this.handleMap;
    }

    public void flush() {
        try {
            this.rocksdb.flush(this.rocksDBOptions.getFlushOptions());
        }
        catch (RocksDBException e) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.runError("rocksdb compact error"), (Throwable)e);
        }
    }

    public void compact() {
        try {
            this.rocksdb.compactRange();
        }
        catch (RocksDBException e) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.runError("rocksdb compact error"), (Throwable)e);
        }
    }

    public void checkpoint(String path) {
        Checkpoint checkpoint = Checkpoint.create((RocksDB)this.rocksdb);
        FileUtils.deleteQuietly((File)new File(path));
        try {
            checkpoint.createCheckpoint(path);
        }
        catch (RocksDBException e) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.runError("rocksdb chk error"), (Throwable)e);
        }
        checkpoint.close();
    }

    public void write(WriteBatch writeBatch) {
        try {
            this.rocksdb.write(this.rocksDBOptions.getWriteOptions(), writeBatch);
        }
        catch (RocksDBException e) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.runError("rocksdb put error"), (Throwable)e);
        }
    }

    public void write(String cf, byte[] key, byte[] value) {
        try {
            this.rocksdb.put(this.handleMap.get(cf), key, value);
        }
        catch (RocksDBException e) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.runError("rocksdb put error"), (Throwable)e);
        }
    }

    public void write(String cf, List<Tuple<byte[], byte[]>> list) {
        try {
            WriteBatch writeBatch = new WriteBatch();
            for (Tuple<byte[], byte[]> tuple : list) {
                writeBatch.put(this.handleMap.get(cf), (byte[])tuple.f0, (byte[])tuple.f1);
            }
            this.rocksdb.write(this.rocksDBOptions.getWriteOptions(), writeBatch);
            writeBatch.clear();
            writeBatch.close();
        }
        catch (RocksDBException e) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.runError("rocksdb put error"), (Throwable)e);
        }
    }

    public byte[] get(String cf, byte[] key) {
        try {
            return this.rocksdb.get(this.handleMap.get(cf), key);
        }
        catch (RocksDBException e) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.runError("rocksdb get error"), (Throwable)e);
        }
    }

    public void delete(String cf, byte[] key) {
        try {
            this.rocksdb.delete(this.handleMap.get(cf), key);
        }
        catch (RocksDBException e) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.runError("rocksdb delete error"), (Throwable)e);
        }
    }

    public RocksIterator getIterator(String cf) {
        return this.rocksdb.newIterator(this.handleMap.get(cf));
    }

    public void close() {
        if (this.rocksdb != null) {
            this.rocksdb.close();
            this.rocksDBOptions.close();
            this.descriptors.forEach(d -> d.getOptions().close());
            this.rocksDBOptions = null;
            this.rocksdb = null;
        }
    }

    public void drop() {
        this.close();
        FileUtils.deleteQuietly((File)new File(this.filePath));
    }
}

