/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.rocksdb;

import com.antgroup.geaflow.common.config.ConfigKey;
import com.antgroup.geaflow.common.config.ConfigKeys;
import com.antgroup.geaflow.store.rocksdb.options.DefaultGraphOptions;

public class RocksdbConfigKeys {
    public static final String CHK_SUFFIX = "_chk";
    public static final String DEFAULT_CF = "default";
    public static final String VERTEX_CF = "default";
    public static final String EDGE_CF = "e";
    public static final String VERTEX_INDEX_CF = "v_index";
    public static final char FILE_DOT = '.';
    public static final ConfigKey ROCKSDB_OPTION_CLASS = ConfigKeys.key((String)"geaflow.store.rocksdb.option.class").defaultValue((Object)DefaultGraphOptions.class.getCanonicalName()).description("rocksdb option class");
    public static final ConfigKey ROCKSDB_OPTIONS_TABLE_BLOCK_SIZE = ConfigKeys.key((String)"geaflow.store.rocksdb.table.block.size").defaultValue((Object)131072L).description("rocksdb table block size, default 128KB");
    public static final ConfigKey ROCKSDB_OPTIONS_TABLE_BLOCK_CACHE_SIZE = ConfigKeys.key((String)"geaflow.store.rocksdb.table.block.cache.size").defaultValue((Object)0x40000000L).description("rocksdb table block cache size, default 1G");
    public static final ConfigKey ROCKSDB_OPTIONS_MAX_WRITER_BUFFER_NUM = ConfigKeys.key((String)"geaflow.store.rocksdb.max.write.buffer.number").defaultValue((Object)2).description("rocksdb max write buffer number, default 2");
    public static final ConfigKey ROCKSDB_OPTIONS_WRITER_BUFFER_SIZE = ConfigKeys.key((String)"geaflow.store.rocksdb.write.buffer.size").defaultValue((Object)0x8000000L).description("rocksdb write buffer size, default 128MB");
    public static final ConfigKey ROCKSDB_OPTIONS_TARGET_FILE_SIZE = ConfigKeys.key((String)"geaflow.store.rocksdb.target.file.size").defaultValue((Object)0x40000000L).description("rocksdb target file size, default 1GB");
    public static final ConfigKey ROCKSDB_STATISTICS_ENABLE = ConfigKeys.key((String)"geaflow.store.rocksdb.statistics.enable").defaultValue((Object)false).description("rocksdb statistics, default false");
    public static final ConfigKey ROCKSDB_TTL_SECOND = ConfigKeys.key((String)"geaflow.store.rocksdb.ttl.second").defaultValue((Object)315360000).description("rocksdb default ttl, default never ttl");
    public static final ConfigKey ROCKSDB_PERSISTENT_CLEAN_THREAD_SIZE = ConfigKeys.key((String)"geaflow.store.rocksdb.persistent.clean.thread.size").defaultValue((Object)4).description("rocksdb persistent clean thread size, default 4");

    public static String getChkPath(String path, long checkpointId) {
        return path + CHK_SUFFIX + checkpointId;
    }

    public static boolean isChkPath(String path) {
        return path.contains(CHK_SUFFIX) && path.indexOf(46) == -1;
    }

    public static String getChkPathPrefix(String path) {
        int end = path.indexOf(CHK_SUFFIX) + CHK_SUFFIX.length();
        return path.substring(0, end);
    }

    public static long getChkIdFromChkPath(String path) {
        return Long.parseLong(path.substring(path.lastIndexOf("chk") + 3));
    }
}

