/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.rocksdb;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.state.DataModel;
import com.antgroup.geaflow.state.StoreType;
import com.antgroup.geaflow.store.IBaseStore;
import com.antgroup.geaflow.store.IStoreBuilder;
import com.antgroup.geaflow.store.StoreDesc;
import com.antgroup.geaflow.store.rocksdb.GraphMultiVersionedRocksdbStore;
import com.antgroup.geaflow.store.rocksdb.GraphRocksdbStore;
import com.antgroup.geaflow.store.rocksdb.KVRocksdbStore;
import java.util.Arrays;
import java.util.List;

public class RocksdbStoreBuilder
implements IStoreBuilder {
    private static final StoreDesc STORE_DESC = new RocksdbStoreDesc();

    public IBaseStore getStore(DataModel type, Configuration config) {
        switch (type) {
            case KV: {
                return new KVRocksdbStore();
            }
            case STATIC_GRAPH: {
                return new GraphRocksdbStore();
            }
            case DYNAMIC_GRAPH: {
                return new GraphMultiVersionedRocksdbStore();
            }
        }
        throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError("not support " + type));
    }

    public StoreDesc getStoreDesc() {
        return STORE_DESC;
    }

    public List<DataModel> supportedDataModel() {
        return Arrays.asList(DataModel.KV, DataModel.DYNAMIC_GRAPH, DataModel.STATIC_GRAPH);
    }

    public static class RocksdbStoreDesc
    implements StoreDesc {
        public boolean isLocalStore() {
            return true;
        }

        public String name() {
            return StoreType.ROCKSDB.name();
        }
    }
}

