/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.rocksdb.iterator;

import com.antgroup.geaflow.model.graph.edge.IEdge;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EdgeListScanIterator<K, EV>
implements Iterator<List<IEdge<K, EV>>> {
    private final Iterator<IEdge<K, EV>> edgeIterator;
    private IEdge<K, EV> residualEdge;
    private List<IEdge<K, EV>> nextValue;

    public EdgeListScanIterator(Iterator<IEdge<K, EV>> edgeIterator) {
        this.edgeIterator = edgeIterator;
    }

    @Override
    public boolean hasNext() {
        this.nextValue = this.getEdgesFromIterator();
        return this.nextValue.size() != 0;
    }

    @Override
    public List<IEdge<K, EV>> next() {
        return this.nextValue;
    }

    private List<IEdge<K, EV>> getEdgesFromIterator() {
        ArrayList<IEdge<K, EV>> list = new ArrayList<IEdge<K, EV>>();
        IEdge<K, EV> lastResidualEdge = this.residualEdge;
        Object key = null;
        if (this.residualEdge != null) {
            list.add(this.residualEdge);
            key = this.residualEdge.getSrcId();
        }
        while (this.edgeIterator.hasNext()) {
            IEdge<K, EV> edge = this.edgeIterator.next();
            if (key == null) {
                key = edge.getSrcId();
            }
            if (edge.getSrcId().equals(key)) {
                list.add(edge);
                continue;
            }
            this.residualEdge = edge;
            break;
        }
        if (lastResidualEdge == this.residualEdge) {
            this.residualEdge = null;
        }
        return list;
    }
}

